/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.BaseField;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.pv.Array;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Type;
import org.epics.pvdata.pv.Union;
import org.epics.pvdata.pv.UnionArray;

public class BaseUnionArray
extends BaseField
implements UnionArray {
    private static Convert convert = ConvertFactory.getConvert();
    private final Union union;

    public BaseUnionArray(Union elementUnion) {
        super(Type.unionArray);
        if (elementUnion == null) {
            throw new NullPointerException("elementUnion is null");
        }
        this.union = elementUnion;
    }

    @Override
    public String getID() {
        return this.union.getID() + "[]";
    }

    @Override
    public Union getUnion() {
        return this.union;
    }

    @Override
    public void toString(StringBuilder buf, int indentLevel) {
        buf.append(this.getID());
        convert.newLine(buf, indentLevel + 1);
        this.union.toString(buf, indentLevel + 1);
    }

    public int hashCode() {
        return 0x80 | this.union.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseUnionArray other = (BaseUnionArray)obj;
        return this.union.equals(other.union);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        if (this.union.isVariant()) {
            buffer.put((byte)-118);
        } else {
            buffer.put((byte)-119);
            control.cachedSerialize(this.union, buffer);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        throw new RuntimeException("not valid operation, use FieldCreate.deserialize instead");
    }

    @Override
    public Array.ArraySizeType getArraySizeType() {
        return Array.ArraySizeType.variable;
    }

    @Override
    public int getMaximumCapacity() {
        return 0;
    }
}

