/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.BaseField;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.pv.Array;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.StructureArray;
import org.epics.pvdata.pv.Type;

public class BaseStructureArray
extends BaseField
implements StructureArray {
    private static Convert convert = ConvertFactory.getConvert();
    private final Structure structure;

    public BaseStructureArray(Structure elementStructure) {
        super(Type.structureArray);
        if (elementStructure == null) {
            throw new NullPointerException("elementStructure is null");
        }
        this.structure = elementStructure;
    }

    @Override
    public String getID() {
        return this.structure.getID() + "[]";
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public void toString(StringBuilder buf, int indentLevel) {
        buf.append(this.getID());
        convert.newLine(buf, indentLevel + 1);
        this.structure.toString(buf, indentLevel + 1);
    }

    public int hashCode() {
        return 8 | this.structure.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseStructureArray other = (BaseStructureArray)obj;
        return this.structure.equals(other.structure);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        buffer.put((byte)-120);
        control.cachedSerialize(this.structure, buffer);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        throw new RuntimeException("not valid operation, use FieldCreate.deserialize instead");
    }

    @Override
    public Array.ArraySizeType getArraySizeType() {
        return Array.ArraySizeType.variable;
    }

    @Override
    public int getMaximumCapacity() {
        return 0;
    }
}

