/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.BaseField;
import org.epics.pvdata.factory.BaseUnion;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.StructureArray;
import org.epics.pvdata.pv.Type;
import org.epics.pvdata.pv.Union;
import org.epics.pvdata.pv.UnionArray;

public class BaseStructure
extends BaseField
implements Structure {
    private static Convert convert = ConvertFactory.getConvert();
    private final String id;
    private Field[] fields;
    private String[] fieldNames;
    private static final String EMPTY_ID = "";

    public BaseStructure(String[] fieldNames, Field[] fields) {
        this("structure", fieldNames, fields);
    }

    public BaseStructure(String id, String[] fieldNames, Field[] fields) {
        super(Type.structure);
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (id.isEmpty()) {
            throw new IllegalArgumentException("id is empty");
        }
        if (fieldNames.length != fields.length) {
            throw new IllegalArgumentException("fieldNames has different length than fields");
        }
        this.id = id;
        this.fields = fields;
        this.fieldNames = fieldNames;
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fieldNames[i];
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName " + i + " is null");
            }
            if (fieldName.length() < 1) {
                throw new IllegalArgumentException("fieldName " + i + " has length 0");
            }
            for (int j = i + 1; j < fields.length; ++j) {
                if (!fieldName.equals(fieldNames[j])) continue;
                throw new IllegalArgumentException("fieldName " + fieldName + " appears more than once");
            }
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    void clone(Field[] fields, String[] fieldNames) {
        this.fields = fields;
        this.fieldNames = fieldNames;
        int n = fieldNames.length;
        for (int i = 0; i < n; ++i) {
            if (fields[i].getType() != Type.structure) continue;
            BaseStructure sub = (BaseStructure)fields[i];
            String[] subNames = sub.getFieldNames();
            Field[] subFields = sub.getFields();
            int m = subNames.length;
            String[] newNames = new String[m];
            Field[] newFields = new Field[m];
            for (int j = 0; j < m; ++j) {
                newNames[j] = subNames[j];
                newFields[j] = subFields[j];
            }
            sub.clone(newFields, newNames);
        }
    }

    @Override
    public Field getField(String name) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!name.equals(this.fieldNames[i])) continue;
            return this.fields[i];
        }
        return null;
    }

    @Override
    public int getFieldIndex(String name) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!name.equals(this.fieldNames[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Field getField(int fieldIndex) {
        return this.fields[fieldIndex];
    }

    @Override
    public <T extends Field> T getField(Class<T> c, String fieldName) {
        Field pv = this.getField(fieldName);
        if (c.isInstance(pv)) {
            return (T)((Field)c.cast(pv));
        }
        return null;
    }

    @Override
    public <T extends Field> T getField(Class<T> c, int fieldOffset) {
        Field pv = this.getField(fieldOffset);
        if (c.isInstance(pv)) {
            return (T)((Field)c.cast(pv));
        }
        return null;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public String getFieldName(int fieldIndex) {
        return this.fieldNames[fieldIndex];
    }

    @Override
    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public void toString(StringBuilder buf, int indentLevel) {
        buf.append(this.getID());
        this.toStringCommon(buf, indentLevel + 1);
    }

    void toStringCommon(StringBuilder buf, int indentLevel) {
        convert.newLine(buf, indentLevel);
        int length = this.fields.length;
        for (int i = 0; i < length; ++i) {
            Field field = this.fields[i];
            buf.append(field.getID() + " " + this.fieldNames[i]);
            Type type = field.getType();
            switch (type) {
                case scalar: 
                case scalarArray: {
                    break;
                }
                case structure: {
                    BaseStructure struct = (BaseStructure)field;
                    struct.toStringCommon(buf, indentLevel + 1);
                    break;
                }
                case structureArray: {
                    convert.newLine(buf, indentLevel + 1);
                    Structure structureField = ((StructureArray)field).getStructure();
                    structureField.toString(buf, indentLevel + 1);
                    break;
                }
                case union: {
                    BaseUnion union = (BaseUnion)field;
                    union.toStringCommon(buf, indentLevel + 1);
                    break;
                }
                case unionArray: {
                    convert.newLine(buf, indentLevel + 1);
                    Union unionField = ((UnionArray)field).getUnion();
                    unionField.toString(buf, indentLevel + 1);
                }
            }
            if (i >= length - 1) continue;
            convert.newLine(buf, indentLevel);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        return this.id.hashCode() + 31 * (31 * Arrays.hashCode(this.fieldNames) + Arrays.hashCode(this.fields));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseStructure other = (BaseStructure)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (!Arrays.equals(this.fieldNames, other.fieldNames)) {
            return false;
        }
        return Arrays.equals(this.fields, other.fields);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        buffer.put((byte)-128);
        BaseStructure.serializeStructureField(this, buffer, control);
    }

    static void serializeStructureField(Structure structure, ByteBuffer buffer, SerializableControl control) {
        String id = structure.getID();
        String idToSerialize = id == "structure" ? EMPTY_ID : id;
        SerializeHelper.serializeString(idToSerialize, buffer, control);
        Field[] fields = structure.getFields();
        String[] fieldNames = structure.getFieldNames();
        SerializeHelper.writeSize(fields.length, buffer, control);
        for (int i = 0; i < fields.length; ++i) {
            SerializeHelper.serializeString(fieldNames[i], buffer, control);
            control.cachedSerialize(fields[i], buffer);
        }
    }

    static final Structure deserializeStructureField(ByteBuffer buffer, DeserializableControl control) {
        String id = SerializeHelper.deserializeString(buffer, control);
        int size = SerializeHelper.readSize(buffer, control);
        Field[] fields = new Field[size];
        String[] fieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            fieldNames[i] = SerializeHelper.deserializeString(buffer, control);
            fields[i] = control.cachedDeserialize(buffer);
        }
        if (id == null || id.isEmpty()) {
            return new BaseStructure(fieldNames, fields);
        }
        return new BaseStructure(id, fieldNames, fields);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        throw new RuntimeException("not valid operation, use FieldCreate.deserialize instead");
    }
}

