/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.BaseField;
import org.epics.pvdata.factory.BaseScalar;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.Array;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Type;

public class BaseScalarBoundedArray
extends BaseField
implements ScalarArray {
    private final ScalarType elementType;
    private final int size;
    private final String id;

    public BaseScalarBoundedArray(ScalarType elementType, int size) {
        super(Type.scalarArray);
        if (elementType == null) {
            throw new NullPointerException("elementType is null");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.elementType = elementType;
        this.size = size;
        this.id = BaseScalar.idLUT[this.elementType.ordinal()] + "<" + size + ">";
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public ScalarType getElementType() {
        return this.elementType;
    }

    @Override
    public void toString(StringBuilder buf, int indentLevel) {
        buf.append(this.getID());
    }

    public int hashCode() {
        return 0x10 | this.elementType.ordinal();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseScalarBoundedArray other = (BaseScalarBoundedArray)obj;
        if (!this.elementType.equals((Object)other.elementType)) {
            return false;
        }
        return this.size == other.size;
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        buffer.put((byte)(0x10 | BaseScalar.typeCodeLUT[this.elementType.ordinal()]));
        SerializeHelper.writeSize(this.size, buffer, control);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        throw new RuntimeException("not valid operation, use FieldCreate.deserialize instead");
    }

    @Override
    public Array.ArraySizeType getArraySizeType() {
        return Array.ArraySizeType.bounded;
    }

    @Override
    public int getMaximumCapacity() {
        return this.size;
    }
}

