/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.BaseField;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Type;

public class BaseScalar
extends BaseField
implements Scalar {
    private final ScalarType scalarType;
    public static final String[] idLUT = new String[]{"boolean", "byte", "short", "int", "long", "ubyte", "ushort", "uint", "ulong", "float", "double", "string"};
    public static final byte[] typeCodeLUT = new byte[]{0, 32, 33, 34, 35, 36, 37, 38, 39, 66, 67, 96};

    public BaseScalar(ScalarType scalarType) {
        super(Type.scalar);
        if (scalarType == null) {
            throw new NullPointerException("scalarType is null");
        }
        this.scalarType = scalarType;
    }

    @Override
    public String getID() {
        return idLUT[this.scalarType.ordinal()];
    }

    @Override
    public ScalarType getScalarType() {
        return this.scalarType;
    }

    @Override
    public void toString(StringBuilder buf, int indentLevel) {
        buf.append(this.getID());
    }

    public int hashCode() {
        return this.scalarType.ordinal();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseScalar other = (BaseScalar)obj;
        return this.scalarType.equals((Object)other.scalarType);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        buffer.put(typeCodeLUT[this.scalarType.ordinal()]);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        throw new RuntimeException("not valid operation, use FieldCreate.deserialize instead");
    }
}

