/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVComplexArray;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVUnion;
import org.epics.pvdata.pv.PVUnionArray;
import org.epics.pvdata.pv.Serializable;
import org.epics.pvdata.pv.Union;
import org.epics.pvdata.pv.UnionArray;
import org.epics.pvdata.pv.UnionArrayData;

public class BasePVUnionArray
extends AbstractPVComplexArray
implements PVUnionArray {
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    protected PVUnion[] value;
    protected UnionArray unionArray;

    public BasePVUnionArray(UnionArray unionArray) {
        super(unionArray);
        this.unionArray = unionArray;
    }

    @Override
    public UnionArray getUnionArray() {
        return this.unionArray;
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new PVUnion[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (PVUnion[])array;
    }

    @Override
    public int get(int offset, int len, UnionArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public int put(int offset, int len, PVUnion[] from, int fromOffset) {
        Union elementField = this.unionArray.getUnion();
        for (PVUnion pvu : from) {
            if (pvu == null || pvu.getUnion().equals(elementField)) continue;
            throw new IllegalStateException("element is not a compatible union");
        }
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(PVUnion[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVUnionArray b = (PVUnionArray)obj;
        UnionArrayData arrayData = new UnionArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((Object[])arrayData.data, this.value);
    }

    @Override
    protected Serializable getAt(int index) {
        return this.value[index];
    }

    @Override
    protected void setAt(int index, Serializable obj) {
        this.value[index] = (PVUnion)obj;
    }

    @Override
    protected Serializable createNewInstance() {
        return pvDataCreate.createPVUnion(this.unionArray.getUnion());
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

