/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVScalarArray;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.IntArrayData;
import org.epics.pvdata.pv.PVUIntArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.util.array.ArrayUInteger;
import org.epics.util.array.CollectionNumbers;

public class BasePVUIntArray
extends AbstractPVScalarArray
implements PVUIntArray {
    protected int[] value;

    public BasePVUIntArray(ScalarArray array) {
        super(array);
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new int[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (int[])array;
    }

    @Override
    protected int putToBuffer(ByteBuffer buffer, SerializableControl control, int offset, int length) {
        buffer.asIntBuffer().put(this.value, offset, length);
        buffer.position(buffer.position() + length * 4);
        return length;
    }

    @Override
    protected int getFromBuffer(ByteBuffer buffer, DeserializableControl control, int offset, int length) {
        buffer.asIntBuffer().get(this.value, offset, length);
        buffer.position(buffer.position() + length * 4);
        return length;
    }

    @Override
    public int get(int offset, int len, IntArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public ArrayUInteger get() {
        return CollectionNumbers.unmodifiableListUInt((int[])this.value);
    }

    @Override
    public int put(int offset, int len, int[] from, int fromOffset) {
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(int[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVUIntArray b = (PVUIntArray)obj;
        IntArrayData arrayData = new IntArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((int[])arrayData.data, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

