/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.AbstractPVScalar;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVUInt;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.SerializableControl;

public class BasePVUInt
extends AbstractPVScalar
implements PVUInt {
    protected int value = 0;

    public BasePVUInt(Scalar scalar) {
        super(scalar);
    }

    @Override
    public int get() {
        return this.value;
    }

    @Override
    public void put(int value) {
        if (super.isImmutable()) {
            throw new IllegalArgumentException("field is immutable");
        }
        this.value = value;
        super.postPut();
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher) {
        flusher.ensureBuffer(4);
        buffer.putInt(this.value);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        control.ensureData(4);
        this.value = buffer.getInt();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PVUInt) {
            PVUInt b = (PVUInt)obj;
            return b.get() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }
}

