/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.AbstractPVScalar;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.BoundedString;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.SerializableControl;

public class BasePVString
extends AbstractPVScalar
implements PVString {
    protected String value = "";
    protected final int maxLength;

    public BasePVString(Scalar scalar) {
        super(scalar);
        this.maxLength = scalar instanceof BoundedString ? ((BoundedString)scalar).getMaximumLength() : 0;
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public void put(String value) {
        if (super.isImmutable()) {
            throw new IllegalArgumentException("field is immutable");
        }
        if (this.maxLength > 0 && value.length() > this.maxLength) {
            throw new IllegalArgumentException("string length out of bounds");
        }
        this.value = value;
        super.postPut();
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher) {
        SerializeHelper.serializeString(this.value, buffer, flusher);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher, int offset, int count) {
        int maxCount;
        int length;
        int n = length = this.value == null ? 0 : this.value.length();
        if (offset < 0) {
            offset = 0;
        } else if (offset > length) {
            offset = length;
        }
        if (count < 0) {
            count = length;
        }
        if (count > (maxCount = length - offset)) {
            count = maxCount;
        }
        SerializeHelper.serializeSubstring(this.value, offset, count, buffer, flusher);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        this.value = SerializeHelper.deserializeString(buffer, control);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PVString) {
            PVString b = (PVString)obj;
            String bv = b.get();
            if (bv != null) {
                return bv.equals(this.value);
            }
            return this.value == null;
        }
        return false;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }
}

