/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVScalarArray;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.LongArrayData;
import org.epics.pvdata.pv.PVLongArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.util.array.ArrayLong;
import org.epics.util.array.CollectionNumbers;

public class BasePVLongArray
extends AbstractPVScalarArray
implements PVLongArray {
    protected long[] value;

    public BasePVLongArray(ScalarArray array) {
        super(array);
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new long[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (long[])array;
    }

    @Override
    protected int putToBuffer(ByteBuffer buffer, SerializableControl control, int offset, int length) {
        buffer.asLongBuffer().put(this.value, offset, length);
        buffer.position(buffer.position() + length * 8);
        return length;
    }

    @Override
    protected int getFromBuffer(ByteBuffer buffer, DeserializableControl control, int offset, int length) {
        buffer.asLongBuffer().get(this.value, offset, length);
        buffer.position(buffer.position() + length * 8);
        return length;
    }

    @Override
    public int get(int offset, int len, LongArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public ArrayLong get() {
        return CollectionNumbers.unmodifiableListLong((long[])this.value);
    }

    @Override
    public int put(int offset, int len, long[] from, int fromOffset) {
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(long[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVLongArray b = (PVLongArray)obj;
        LongArrayData arrayData = new LongArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((long[])arrayData.data, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

