/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVScalarArray;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.FloatArrayData;
import org.epics.pvdata.pv.PVFloatArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.util.array.ArrayFloat;
import org.epics.util.array.CollectionNumbers;

public class BasePVFloatArray
extends AbstractPVScalarArray
implements PVFloatArray {
    protected float[] value;

    public BasePVFloatArray(ScalarArray array) {
        super(array);
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new float[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (float[])array;
    }

    @Override
    protected int putToBuffer(ByteBuffer buffer, SerializableControl control, int offset, int length) {
        buffer.asFloatBuffer().put(this.value, offset, length);
        buffer.position(buffer.position() + length * 4);
        return length;
    }

    @Override
    protected int getFromBuffer(ByteBuffer buffer, DeserializableControl control, int offset, int length) {
        buffer.asFloatBuffer().get(this.value, offset, length);
        buffer.position(buffer.position() + length * 4);
        return length;
    }

    @Override
    public int get(int offset, int len, FloatArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public ArrayFloat get() {
        return CollectionNumbers.unmodifiableListFloat((float[])this.value);
    }

    @Override
    public int put(int offset, int len, float[] from, int fromOffset) {
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(float[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVFloatArray b = (PVFloatArray)obj;
        FloatArrayData arrayData = new FloatArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((float[])arrayData.data, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

