/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.AbstractPVScalar;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVFloat;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.SerializableControl;

public class BasePVFloat
extends AbstractPVScalar
implements PVFloat {
    protected float value = 0.0f;

    public BasePVFloat(Scalar scalar) {
        super(scalar);
    }

    @Override
    public float get() {
        return this.value;
    }

    @Override
    public void put(float value) {
        if (super.isImmutable()) {
            throw new IllegalArgumentException("field is immutable");
        }
        this.value = value;
        super.postPut();
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher) {
        flusher.ensureBuffer(4);
        buffer.putFloat(this.value);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        control.ensureData(4);
        this.value = buffer.getFloat();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PVFloat) {
            PVFloat b = (PVFloat)obj;
            return b.get() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.value;
    }
}

