/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVScalarArray;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.DoubleArrayData;
import org.epics.pvdata.pv.PVDoubleArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionNumbers;

public class BasePVDoubleArray
extends AbstractPVScalarArray
implements PVDoubleArray {
    protected double[] value;

    public BasePVDoubleArray(ScalarArray array) {
        super(array);
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new double[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (double[])array;
    }

    @Override
    protected int putToBuffer(ByteBuffer buffer, SerializableControl control, int offset, int length) {
        buffer.asDoubleBuffer().put(this.value, offset, length);
        buffer.position(buffer.position() + length * 8);
        return length;
    }

    @Override
    protected int getFromBuffer(ByteBuffer buffer, DeserializableControl control, int offset, int length) {
        buffer.asDoubleBuffer().get(this.value, offset, length).position();
        buffer.position(buffer.position() + length * 8);
        return length;
    }

    @Override
    public int get(int offset, int len, DoubleArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public ArrayDouble get() {
        return CollectionNumbers.unmodifiableListDouble((double[])this.value);
    }

    @Override
    public int put(int offset, int len, double[] from, int fromOffset) {
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(double[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVDoubleArray b = (PVDoubleArray)obj;
        DoubleArrayData arrayData = new DoubleArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((double[])arrayData.data, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

