/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVScalarArray;
import org.epics.pvdata.pv.ByteArrayData;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVByteArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.util.array.ArrayByte;
import org.epics.util.array.CollectionNumbers;

public class BasePVByteArray
extends AbstractPVScalarArray
implements PVByteArray {
    protected byte[] value;

    public BasePVByteArray(ScalarArray array) {
        super(array);
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new byte[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (byte[])array;
    }

    @Override
    protected int putToBuffer(ByteBuffer buffer, SerializableControl control, int offset, int length) {
        buffer.put(this.value, offset, length);
        return length;
    }

    @Override
    protected int getFromBuffer(ByteBuffer buffer, DeserializableControl control, int offset, int length) {
        buffer.get(this.value, offset, length);
        return length;
    }

    @Override
    public int get(int offset, int len, ByteArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public ArrayByte get() {
        return CollectionNumbers.unmodifiableListByte((byte[])this.value);
    }

    @Override
    public int put(int offset, int len, byte[] from, int fromOffset) {
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(byte[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVByteArray b = (PVByteArray)obj;
        ByteArrayData arrayData = new ByteArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((byte[])arrayData.data, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

