/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVScalarArray;
import org.epics.pvdata.pv.BooleanArrayData;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVBooleanArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;

public class BasePVBooleanArray
extends AbstractPVScalarArray
implements PVBooleanArray {
    protected boolean[] value;

    public BasePVBooleanArray(ScalarArray array) {
        super(array);
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new boolean[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (boolean[])array;
    }

    @Override
    protected int putToBuffer(ByteBuffer buffer, SerializableControl control, int offset, int length) {
        int end = length + offset;
        for (int i = offset; i < end; ++i) {
            buffer.put(this.value[i] ? (byte)1 : 0);
        }
        return length;
    }

    @Override
    protected int getFromBuffer(ByteBuffer buffer, DeserializableControl control, int offset, int length) {
        int end = length + offset;
        for (int i = offset; i < end; ++i) {
            this.value[i] = buffer.get() != 0;
        }
        return length;
    }

    @Override
    public int get(int offset, int len, BooleanArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public int put(int offset, int len, boolean[] from, int fromOffset) {
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(boolean[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVBooleanArray b = (PVBooleanArray)obj;
        BooleanArrayData arrayData = new BooleanArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((boolean[])arrayData.data, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

