/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.util.LinkedHashMap;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.pv.BoundedString;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldBuilder;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.Union;

public class BaseFieldBuilder
implements FieldBuilder {
    private static FieldCreate fieldCreate = FieldFactory.getFieldCreate();
    private String id;
    private final LinkedHashMap<String, Field> members = new LinkedHashMap();
    private final FieldBuilder parentBuilder;
    private final Class<? extends Field> nestedClassToBuild;
    private final String nestedName;
    private final boolean nestedArray;

    public BaseFieldBuilder() {
        this.parentBuilder = null;
        this.nestedClassToBuild = null;
        this.nestedName = null;
        this.nestedArray = false;
    }

    private BaseFieldBuilder(FieldBuilder parentBuilder, String nestedName, Class<? extends Field> nestedClassToBuild, boolean nestedArray) {
        this.parentBuilder = parentBuilder;
        this.nestedClassToBuild = nestedClassToBuild;
        this.nestedName = nestedName;
        this.nestedArray = nestedArray;
    }

    private void reset() {
        this.id = null;
        this.members.clear();
    }

    @Override
    public FieldBuilder setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public FieldBuilder add(String name, ScalarType scalarType) {
        this.members.put(name, fieldCreate.createScalar(scalarType));
        return this;
    }

    @Override
    public FieldBuilder addBoundedString(String name, int maxLength) {
        this.members.put(name, fieldCreate.createBoundedString(maxLength));
        return this;
    }

    @Override
    public FieldBuilder add(String name, Field field) {
        this.members.put(name, field);
        return this;
    }

    @Override
    public FieldBuilder addArray(String name, ScalarType scalarType) {
        this.members.put(name, fieldCreate.createScalarArray(scalarType));
        return this;
    }

    @Override
    public FieldBuilder addFixedArray(String name, ScalarType scalarType, int size) {
        this.members.put(name, fieldCreate.createFixedScalarArray(scalarType, size));
        return this;
    }

    @Override
    public FieldBuilder addBoundedArray(String name, ScalarType scalarType, int bound) {
        this.members.put(name, fieldCreate.createBoundedScalarArray(scalarType, bound));
        return this;
    }

    @Override
    public FieldBuilder addArray(String name, Field element) {
        if (element instanceof Structure) {
            this.members.put(name, fieldCreate.createStructureArray((Structure)element));
        } else if (element instanceof Union) {
            this.members.put(name, fieldCreate.createUnionArray((Union)element));
        } else if (element instanceof Scalar) {
            if (element instanceof BoundedString) {
                throw new IllegalArgumentException("bounded string arrays are not supported");
            }
            this.members.put(name, fieldCreate.createScalarArray(((Scalar)element).getScalarType()));
        } else {
            throw new IllegalArgumentException("unsupported array element type:" + element.getClass());
        }
        return this;
    }

    private <T> T createFieldInternal(Class<T> type) {
        int size = this.members.size();
        if (size == 0 && type.equals(Union.class)) {
            return type.cast(fieldCreate.createVariantUnion());
        }
        String[] fieldNames = new String[size];
        this.members.keySet().toArray(fieldNames);
        Field[] fields = new Field[size];
        this.members.values().toArray(fields);
        if (type.equals(Structure.class)) {
            Structure structure = this.id != null ? fieldCreate.createStructure(this.id, fieldNames, fields) : fieldCreate.createStructure(fieldNames, fields);
            return type.cast(structure);
        }
        if (type.equals(Union.class)) {
            Union union = this.id != null ? fieldCreate.createUnion(this.id, fieldNames, fields) : fieldCreate.createUnion(fieldNames, fields);
            return type.cast(union);
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    @Override
    public Structure createStructure() {
        if (this.parentBuilder != null) {
            throw new IllegalStateException("createStructure() called in nested FieldBuilder");
        }
        Structure structure = this.createFieldInternal(Structure.class);
        this.reset();
        return structure;
    }

    @Override
    public Union createUnion() {
        if (this.parentBuilder != null) {
            throw new IllegalStateException("createStructure() called in nested FieldBuilder");
        }
        Union union = this.createFieldInternal(Union.class);
        this.reset();
        return union;
    }

    @Override
    public FieldBuilder addNestedStructure(String name) {
        return new BaseFieldBuilder(this, name, Structure.class, false);
    }

    @Override
    public FieldBuilder addNestedUnion(String name) {
        return new BaseFieldBuilder(this, name, Union.class, false);
    }

    @Override
    public FieldBuilder addNestedStructureArray(String name) {
        return new BaseFieldBuilder(this, name, Structure.class, true);
    }

    @Override
    public FieldBuilder addNestedUnionArray(String name) {
        return new BaseFieldBuilder(this, name, Union.class, true);
    }

    @Override
    public FieldBuilder endNested() {
        if (this.parentBuilder == null) {
            throw new IllegalStateException("this method can only be called to create nested fields");
        }
        Field nestedField = this.createFieldInternal(this.nestedClassToBuild);
        if (this.nestedArray) {
            this.parentBuilder.addArray(this.nestedName, nestedField);
        } else {
            this.parentBuilder.add(this.nestedName, nestedField);
        }
        return this.parentBuilder;
    }
}

