/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.BaseScalar;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.BoundedString;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.SerializableControl;

public class BaseBoundedString
extends BaseScalar
implements BoundedString {
    public final int maxLength;

    public BaseBoundedString(int maxLength) {
        super(ScalarType.pvString);
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength <= 0");
        }
        this.maxLength = maxLength;
    }

    @Override
    public String getID() {
        return super.getID() + '(' + this.maxLength + ')';
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        buffer.put((byte)-125);
        SerializeHelper.writeSize(this.maxLength, buffer, control);
    }

    @Override
    public int getMaximumLength() {
        return this.maxLength;
    }

    @Override
    public int hashCode() {
        return super.hashCode() | this.maxLength << 4;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseBoundedString other = (BaseBoundedString)obj;
        return this.maxLength == other.maxLength;
    }
}

