/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.AbstractPVArray;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.Array;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;

public abstract class AbstractPVScalarArray
extends AbstractPVArray
implements PVScalarArray {
    private static final int[] elementSizeLUT = new int[]{1, 1, 2, 4, 8, 1, 2, 4, 8, 4, 8, -1};

    protected AbstractPVScalarArray(ScalarArray array) {
        super(array);
    }

    @Override
    public ScalarArray getScalarArray() {
        return (ScalarArray)this.getField();
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher, int offset, int count) {
        int maxCount;
        if (offset < 0) {
            offset = 0;
        } else if (offset > this.length) {
            offset = this.length;
        }
        if (count < 0) {
            count = this.length;
        }
        if (count > (maxCount = this.length - offset)) {
            count = maxCount;
        }
        if (this.getArray().getArraySizeType() != Array.ArraySizeType.fixed) {
            SerializeHelper.writeSize(count, buffer, flusher);
        } else if (count != this.getArray().getMaximumCapacity()) {
            throw new IllegalStateException("fixed array cannot be partially serialized");
        }
        int elementSize = this.getElementSize();
        if (elementSize <= 0) {
            this.putToBuffer(buffer, flusher, offset, count);
        } else {
            int n;
            int end = offset + count;
            int i = offset;
            while ((i += this.putToBuffer(buffer, flusher, i, n = Math.min(end - i, buffer.remaining() / elementSize))) < end) {
                flusher.flushSerializeBuffer();
            }
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        int size;
        int n = size = this.getArray().getArraySizeType() != Array.ArraySizeType.fixed ? SerializeHelper.readSize(buffer, control) : this.getArray().getMaximumCapacity();
        if (size >= 0) {
            int elementSize;
            if (size > this.capacity) {
                this.setCapacity(size);
            }
            if ((elementSize = this.getElementSize()) <= 0) {
                this.getFromBuffer(buffer, control, 0, size);
            } else {
                int n2;
                int i = 0;
                while ((i += this.getFromBuffer(buffer, control, i, n2 = Math.min(size - i, buffer.remaining() / elementSize))) < size) {
                    control.ensureData(elementSize);
                }
            }
            this.length = size;
        }
    }

    protected final int getElementSize() {
        return elementSizeLUT[this.getScalarArray().getElementType().ordinal()];
    }

    protected abstract int putToBuffer(ByteBuffer var1, SerializableControl var2, int var3, int var4);

    protected abstract int getFromBuffer(ByteBuffer var1, DeserializableControl var2, int var3, int var4);
}

