/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.AbstractPVArray;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.Array;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Serializable;
import org.epics.pvdata.pv.SerializableControl;

public abstract class AbstractPVComplexArray
extends AbstractPVArray {
    protected AbstractPVComplexArray(Array array) {
        super(array);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher, int offset, int count) {
        int maxCount;
        int length = this.getLength();
        Serializable[] value = (Serializable[])this.getValue();
        if (offset < 0) {
            offset = 0;
        } else if (offset > length) {
            offset = length;
        }
        if (count < 0) {
            count = length;
        }
        if (count > (maxCount = length - offset)) {
            count = maxCount;
        }
        if (this.getArray().getArraySizeType() != Array.ArraySizeType.fixed) {
            SerializeHelper.writeSize(count, buffer, flusher);
        } else if (count != this.getArray().getMaximumCapacity()) {
            throw new IllegalStateException("fixed array cannot be partially serialized");
        }
        for (int i = 0; i < count; ++i) {
            Serializable pvComplex;
            if (buffer.remaining() < 1) {
                flusher.flushSerializeBuffer();
            }
            if ((pvComplex = value[i + offset]) == null) {
                buffer.put((byte)0);
                continue;
            }
            buffer.put((byte)1);
            pvComplex.serialize(buffer, flusher);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        int size;
        int n = size = this.getArray().getArraySizeType() != Array.ArraySizeType.fixed ? SerializeHelper.readSize(buffer, control) : this.getArray().getMaximumCapacity();
        if (size >= 0) {
            if (size > this.capacity) {
                this.setCapacity(size);
            }
            for (int i = 0; i < size; ++i) {
                control.ensureData(1);
                byte nullOrNonNull = buffer.get();
                if (nullOrNonNull == 0) {
                    this.setAt(i, null);
                    continue;
                }
                Serializable obj = this.getAt(i);
                if (obj == null) {
                    obj = this.createNewInstance();
                    this.setAt(i, obj);
                }
                obj.deserialize(buffer, control);
            }
            this.length = size;
        }
    }

    protected abstract Serializable getAt(int var1);

    protected abstract void setAt(int var1, Serializable var2);

    protected abstract Serializable createNewInstance();
}

