/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import org.epics.pvdata.factory.AbstractPVField;
import org.epics.pvdata.pv.Array;
import org.epics.pvdata.pv.ArrayData;
import org.epics.pvdata.pv.PVArray;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.ListNumber;

public abstract class AbstractPVArray
extends AbstractPVField
implements PVArray {
    protected int length = 0;
    protected int capacity = 0;
    protected boolean capacityMutable = true;

    protected AbstractPVArray(org.epics.pvdata.pv.Array field) {
        super(field);
        if (this.getArray().getArraySizeType() == Array.ArraySizeType.fixed) {
            this.capacity = this.length = this.getArray().getMaximumCapacity();
            this.setCapacityMutable(false);
        }
        this.allocate(this.capacity);
    }

    @Override
    public org.epics.pvdata.pv.Array getArray() {
        return (org.epics.pvdata.pv.Array)this.getField();
    }

    protected abstract Object getValue();

    protected abstract void setValue(Object var1);

    protected abstract void allocate(int var1);

    protected abstract boolean valueEquals(Object var1);

    @Override
    public void setCapacity(int newCapacity) {
        if (newCapacity == this.capacity) {
            return;
        }
        if (!this.capacityMutable) {
            throw new IllegalStateException("not capacityMutable");
        }
        this.checkLength(newCapacity);
        Object oldValue = this.getValue();
        this.allocate(newCapacity);
        if (this.length > newCapacity) {
            this.length = newCapacity;
        }
        if (this.length > 0) {
            System.arraycopy(oldValue, 0, this.getValue(), 0, this.length);
        }
    }

    protected int internalGet(int offset, int len, ArrayData<?> data) {
        int n = len;
        if (offset + len > this.length) {
            n = Math.max(0, this.length - offset);
        }
        data.set(this.getValue(), offset);
        return n;
    }

    protected int internalPut(int offset, int len, Object from, int fromOffset) {
        if (super.isImmutable()) {
            throw new IllegalStateException("field is immutable");
        }
        Object value = this.getValue();
        if (from == value) {
            return len;
        }
        int newLength = offset + len;
        if (newLength > this.length) {
            this.checkLength(newLength);
            this.setCapacity(newLength);
            value = this.getValue();
            this.length = newLength;
        }
        System.arraycopy(from, fromOffset, value, offset, len);
        super.postPut();
        return len;
    }

    public void put(int offset, ListNumber list) {
        if (super.isImmutable()) {
            throw new IllegalStateException("field is immutable");
        }
        int newLength = offset + list.size();
        if (newLength > this.length) {
            this.checkLength(newLength);
            this.setCapacity(newLength);
            this.length = newLength;
        }
        CollectionNumbers.toList((Object)this.getValue()).setAll(offset, list);
        super.postPut();
    }

    private void checkLength(int len) {
        Array.ArraySizeType type = this.getArray().getArraySizeType();
        if (type != Array.ArraySizeType.variable) {
            int size = this.getArray().getMaximumCapacity();
            if (type == Array.ArraySizeType.fixed && len != size) {
                throw new IllegalArgumentException("invalid length for a fixed size array");
            }
            if (type == Array.ArraySizeType.bounded && len > size) {
                throw new IllegalArgumentException("new array capacity too large for a bounded size array");
            }
        }
    }

    protected void internalShareData(Object from) {
        int len = Array.getLength(from);
        this.checkLength(len);
        this.setValue(from);
        this.capacity = this.length = len;
    }

    @Override
    public void setImmutable() {
        this.capacityMutable = false;
        super.setImmutable();
    }

    @Override
    public boolean isCapacityMutable() {
        return this.capacityMutable;
    }

    @Override
    public void setCapacityMutable(boolean isMutable) {
        if (isMutable && super.isImmutable()) {
            throw new IllegalStateException("field is immutable");
        }
        this.capacityMutable = isMutable;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int len) {
        if (len == this.length) {
            return;
        }
        if (super.isImmutable()) {
            throw new IllegalStateException("field is immutable");
        }
        this.checkLength(len);
        if (len > this.capacity) {
            this.setCapacity(len);
        }
        this.length = len;
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher) {
        this.serialize(buffer, flusher, 0, -1);
    }

    public boolean equals(Object obj) {
        PVArray other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof PVArray && (other = (PVArray)obj).getField().equals(this.getField())) {
            return other.getLength() == this.getLength() && this.valueEquals(obj);
        }
        return false;
    }
}

