/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.copy;

import java.util.ArrayList;
import org.epics.pvdata.copy.PVCopy;
import org.epics.pvdata.copy.PVCopyTraverseMasterCallback;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.Type;

class PVCopyImpl
implements PVCopy {
    private static final FieldCreate fieldCreate = FieldFactory.getFieldCreate();
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private static final Convert convert = ConvertFactory.getConvert();
    private final PVStructure pvMaster;
    private Structure structure = null;
    private Node headNode = null;
    private PVStructure cacheInitStructure = null;

    static PVCopy create(PVStructure pvMaster, PVStructure pvRequest, String structureName) {
        PVCopyImpl impl;
        boolean result;
        if (structureName != null && structureName.length() > 0 && pvRequest.getPVFields().length > 0 && (pvRequest = pvRequest.getStructureField(structureName)) == null) {
            return null;
        }
        PVStructure pvStruct = pvRequest;
        if (pvRequest.getSubField("field") != null) {
            pvStruct = pvRequest.getStructureField("field");
        }
        if (!(result = (impl = new PVCopyImpl(pvMaster)).init(pvStruct))) {
            return null;
        }
        return impl;
    }

    private PVCopyImpl(PVStructure pvMaster) {
        this.pvMaster = pvMaster;
    }

    @Override
    public PVStructure getPVMaster() {
        return this.pvMaster;
    }

    @Override
    public void traverseMaster(PVCopyTraverseMasterCallback callback) {
        this.traverseMaster(this.headNode, callback);
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public PVStructure createPVStructure() {
        if (this.cacheInitStructure != null) {
            PVStructure save = this.cacheInitStructure;
            this.cacheInitStructure = null;
            return save;
        }
        PVStructure pvStructure = pvDataCreate.createPVStructure(this.structure);
        return pvStructure;
    }

    @Override
    public int getCopyOffset(PVField masterPVField) {
        if (!this.headNode.isStructure) {
            Node node = this.headNode;
            if (node.masterPVField.equals(masterPVField)) {
                return this.headNode.structureOffset;
            }
            PVStructure parent = masterPVField.getParent();
            int offsetParent = parent.getFieldOffset();
            int off = masterPVField.getFieldOffset();
            int offdiff = off - offsetParent;
            if (offdiff < node.nfields) {
                return this.headNode.structureOffset + offdiff;
            }
            return -1;
        }
        Node node = this.getCopyOffset((StructureNode)this.headNode, masterPVField);
        if (node != null) {
            int offset = masterPVField.getFieldOffset() - node.masterPVField.getFieldOffset();
            return node.structureOffset + offset;
        }
        return -1;
    }

    @Override
    public int getCopyOffset(PVStructure masterPVStructure, PVField masterPVField) {
        Node node = null;
        if (!this.headNode.isStructure) {
            node = this.headNode;
            if (node.masterPVField != masterPVStructure) {
                return -1;
            }
        } else {
            node = this.getCopyOffset((StructureNode)this.headNode, (PVField)masterPVStructure);
        }
        if (node == null) {
            return -1;
        }
        int diff = masterPVField.getFieldOffset() - masterPVStructure.getFieldOffset();
        return node.structureOffset + diff;
    }

    @Override
    public PVField getMasterPVField(int structureOffset) {
        Node node = null;
        node = !this.headNode.isStructure ? this.headNode : this.getMasterNode((StructureNode)this.headNode, structureOffset);
        if (node == null) {
            System.err.printf("PVCopy::PVField getRecordPVField(int structureOffset) illegal structureOffset %d %s%n", structureOffset, this.dump());
            throw new IllegalArgumentException("structureOffset not valid");
        }
        int diff = structureOffset - node.structureOffset;
        PVField pvMasterField = node.masterPVField;
        if (diff == 0) {
            return pvMasterField;
        }
        PVStructure pvStructure = (PVStructure)pvMasterField;
        return pvStructure.getSubField(pvMasterField.getFieldOffset() + diff);
    }

    @Override
    public void initCopy(PVStructure copyPVStructure, BitSet bitSet) {
        bitSet.set(0, copyPVStructure.getNumberFields(), true);
        this.updateCopyFromBitSet(copyPVStructure, this.headNode, bitSet);
    }

    @Override
    public void updateCopySetBitSet(PVStructure copyPVStructure, BitSet bitSet) {
        this.updateCopySetBitSet((PVField)copyPVStructure, this.headNode, bitSet);
    }

    @Override
    public void updateCopyFromBitSet(PVStructure copyPVStructure, BitSet bitSet) {
        if (bitSet.get(0)) {
            bitSet.set(0, copyPVStructure.getNumberFields(), true);
        }
        this.updateCopyFromBitSet(copyPVStructure, this.headNode, bitSet);
    }

    @Override
    public void updateMaster(PVStructure copyPVStructure, BitSet bitSet) {
        if (bitSet.get(0)) {
            bitSet.set(0, copyPVStructure.getNumberFields(), true);
        }
        this.updateMaster(copyPVStructure, this.headNode, bitSet);
    }

    @Override
    public PVStructure getOptions(int fieldOffset) {
        boolean okToContinue;
        if (fieldOffset == 0) {
            return this.headNode.options;
        }
        Node node = this.headNode;
        block0: do {
            if (node.structureOffset == fieldOffset) {
                return node.options;
            }
            if (!node.isStructure) {
                return null;
            }
            StructureNode structNode = (StructureNode)node;
            Node[] nodes = structNode.nodes;
            okToContinue = false;
            for (int i = 0; i < nodes.length; ++i) {
                node = nodes[i];
                int soff = node.structureOffset;
                if (fieldOffset < soff || fieldOffset >= soff + node.nfields) continue;
                if (fieldOffset == soff) {
                    return node.options;
                }
                if (!node.isStructure) {
                    return null;
                }
                okToContinue = true;
                continue block0;
            }
        } while (okToContinue);
        throw new IllegalArgumentException("fieldOffset not valid");
    }

    @Override
    public String dump() {
        StringBuilder builder = new StringBuilder();
        this.dump(builder, this.headNode, 0);
        return builder.toString();
    }

    private void traverseMaster(Node innode, PVCopyTraverseMasterCallback callback) {
        Node node = innode;
        if (!node.isStructure) {
            callback.nextMasterPVField(node.masterPVField);
            return;
        }
        StructureNode structNode = (StructureNode)node;
        Node[] nodes = structNode.nodes;
        for (int i = 0; i < nodes.length; ++i) {
            node = nodes[i];
            this.traverseMaster(node, callback);
        }
    }

    private void updateCopySetBitSet(PVField pvCopy, PVField pvMaster, BitSet bitSet) {
        if (pvCopy.getField().getType() != Type.structure) {
            if (pvCopy.equals(pvMaster)) {
                return;
            }
            convert.copy(pvMaster, pvCopy);
            bitSet.set(pvCopy.getFieldOffset());
            return;
        }
        PVStructure pvCopyStructure = (PVStructure)pvCopy;
        PVField[] pvCopyFields = pvCopyStructure.getPVFields();
        int length = pvCopyFields.length;
        for (int i = 0; i < length; ++i) {
            pvMaster = this.getMasterPVField(pvCopyFields[i].getFieldOffset());
            this.updateCopySetBitSet(pvCopyFields[i], pvMaster, bitSet);
        }
    }

    private void updateCopySetBitSet(PVField pvCopy, Node node, BitSet bitSet) {
        boolean result = false;
        if (!node.isStructure) {
            if (result) {
                return;
            }
            this.updateCopySetBitSet(pvCopy, node.masterPVField, bitSet);
            return;
        }
        StructureNode structureNode = (StructureNode)node;
        PVStructure pvCopyStructure = (PVStructure)pvCopy;
        PVField[] pvCopyFields = pvCopyStructure.getPVFields();
        int length = pvCopyFields.length;
        for (int i = 0; i < length; ++i) {
            this.updateCopySetBitSet(pvCopyFields[i], structureNode.nodes[i], bitSet);
        }
    }

    private void updateCopyFromBitSet(PVField pvCopy, Node node, BitSet bitSet) {
        boolean result = false;
        if (!node.isStructure) {
            if (result) {
                return;
            }
            PVField pvMaster = node.masterPVField;
            convert.copy(pvMaster, pvCopy);
            return;
        }
        StructureNode structureNode = (StructureNode)node;
        int offset = structureNode.structureOffset;
        int nextSet = bitSet.nextSetBit(offset);
        if (nextSet == -1) {
            return;
        }
        if (offset >= pvCopy.getNextFieldOffset()) {
            return;
        }
        PVStructure pvCopyStructure = (PVStructure)pvCopy;
        PVField[] pvCopyFields = pvCopyStructure.getPVFields();
        int length = pvCopyFields.length;
        for (int i = 0; i < length; ++i) {
            this.updateCopyFromBitSet(pvCopyFields[i], structureNode.nodes[i], bitSet);
        }
    }

    private void updateMaster(PVField pvCopy, Node node, BitSet bitSet) {
        boolean result = false;
        if (!node.isStructure) {
            if (result) {
                return;
            }
            PVField pvMaster = node.masterPVField;
            convert.copy(pvCopy, pvMaster);
            return;
        }
        StructureNode structureNode = (StructureNode)node;
        int offset = structureNode.structureOffset;
        int nextSet = bitSet.nextSetBit(offset);
        if (nextSet == -1) {
            return;
        }
        if (offset >= pvCopy.getNextFieldOffset()) {
            return;
        }
        PVStructure pvCopyStructure = (PVStructure)pvCopy;
        PVField[] pvCopyFields = pvCopyStructure.getPVFields();
        int length = pvCopyFields.length;
        for (int i = 0; i < length; ++i) {
            this.updateMaster(pvCopyFields[i], structureNode.nodes[i], bitSet);
        }
    }

    private boolean init(PVStructure pvRequest) {
        PVStructure pvMasterStructure = this.pvMaster;
        int len = pvRequest.getPVFields().length;
        boolean entireMaster = false;
        if (len == 0) {
            entireMaster = true;
        }
        PVStructure pvOptions = null;
        if (len == 1 && pvRequest.getSubField("_options") != null) {
            pvOptions = pvRequest.getStructureField("_options");
        }
        if (entireMaster) {
            Node node;
            this.structure = pvMasterStructure.getStructure();
            this.headNode = node = new Node();
            node.options = pvOptions;
            node.isStructure = false;
            node.structureOffset = 0;
            node.masterPVField = pvMasterStructure;
            node.nfields = pvMasterStructure.getNumberFields();
            return true;
        }
        this.structure = PVCopyImpl.createStructure(pvMasterStructure, pvRequest);
        if (this.structure == null) {
            return false;
        }
        this.cacheInitStructure = this.createPVStructure();
        this.headNode = PVCopyImpl.createStructureNodes(this.pvMaster, pvRequest, this.cacheInitStructure);
        return true;
    }

    private static Structure createStructure(PVStructure pvMaster, PVStructure pvFromRequest) {
        if (pvFromRequest.getStructure().getFieldNames().length == 0) {
            return pvMaster.getStructure();
        }
        PVField[] pvFromRequestFields = pvFromRequest.getPVFields();
        String[] fromRequestFieldNames = pvFromRequest.getStructure().getFieldNames();
        int length = pvFromRequestFields.length;
        if (length == 0) {
            return null;
        }
        ArrayList<Field> fieldList = new ArrayList<Field>(length);
        ArrayList<String> fieldNameList = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            PVStructure pvRequestStructure;
            String fieldName = fromRequestFieldNames[i];
            PVField pvMasterField = pvMaster.getSubField(fieldName);
            if (pvMasterField == null) continue;
            Field field = pvMasterField.getField();
            if (field.getType() == Type.structure && (pvRequestStructure = (PVStructure)pvFromRequestFields[i]).getNumberFields() > 0) {
                String[] names = pvRequestStructure.getStructure().getFieldNames();
                int num = names.length;
                if (num > 0 && names[0].equals("_options")) {
                    --num;
                }
                if (num > 0) {
                    if (pvMasterField.getField().getType() != Type.structure) continue;
                    fieldNameList.add(fieldName);
                    fieldList.add(PVCopyImpl.createStructure((PVStructure)pvMasterField, pvRequestStructure));
                    continue;
                }
            }
            fieldNameList.add(fieldName);
            fieldList.add(field);
        }
        int numsubfields = fieldList.size();
        if (numsubfields == 0) {
            return null;
        }
        Field[] fields = new Field[fieldList.size()];
        String[] fieldNames = new String[fieldNameList.size()];
        fields = fieldList.toArray(fields);
        fieldNames = fieldNameList.toArray(fieldNames);
        return fieldCreate.createStructure(fieldNames, fields);
    }

    private static Node createStructureNodes(PVStructure pvMasterStructure, PVStructure pvFromRequest, PVStructure pvFromCopy) {
        PVField[] copyPVFields = pvFromCopy.getPVFields();
        PVStructure pvOptions = null;
        PVField pvField = pvFromRequest.getSubField("_options");
        if (pvField != null) {
            pvOptions = (PVStructure)pvField;
        }
        int number = copyPVFields.length;
        ArrayList<Node> nodeList = new ArrayList<Node>(number);
        for (int i = 0; i < number; ++i) {
            PVField pvMasterField;
            PVField copyPVField = copyPVFields[i];
            String fieldName = copyPVField.getFieldName();
            PVStructure requestPVStructure = (PVStructure)pvFromRequest.getSubField(fieldName);
            PVStructure pvSubFieldOptions = null;
            pvField = requestPVStructure.getSubField("_options");
            if (pvField != null) {
                pvSubFieldOptions = (PVStructure)pvField;
            }
            if ((pvMasterField = pvMasterStructure.getSubField(fieldName)) == null) {
                throw new NullPointerException("did not find field in master");
            }
            int numberRequest = requestPVStructure.getPVFields().length;
            if (pvSubFieldOptions != null) {
                --numberRequest;
            }
            if (numberRequest > 0) {
                nodeList.add(PVCopyImpl.createStructureNodes((PVStructure)pvMasterField, requestPVStructure, (PVStructure)copyPVField));
                continue;
            }
            Node node = new Node();
            node.options = pvSubFieldOptions;
            node.isStructure = false;
            node.masterPVField = pvMasterField;
            node.nfields = copyPVField.getNumberFields();
            node.structureOffset = copyPVField.getFieldOffset();
            nodeList.add(node);
        }
        StructureNode structureNode = new StructureNode();
        Node[] nodes = new Node[number];
        nodeList.toArray(nodes);
        structureNode.masterPVField = pvMasterStructure;
        structureNode.isStructure = true;
        structureNode.nodes = nodes;
        structureNode.structureOffset = pvFromCopy.getFieldOffset();
        structureNode.nfields = pvFromCopy.getNumberFields();
        structureNode.options = pvOptions;
        return structureNode;
    }

    private Node getCopyOffset(StructureNode structureNode, PVField masterPVField) {
        int offset = masterPVField.getFieldOffset();
        Node[] nodes = structureNode.nodes;
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (!node.isStructure) {
                int off = node.masterPVField.getFieldOffset();
                int nextOffset = node.masterPVField.getNextFieldOffset();
                if (offset < off || offset >= nextOffset) continue;
                return node;
            }
            StructureNode subNode = (StructureNode)node;
            if ((node = this.getCopyOffset(subNode, masterPVField)) == null) continue;
            return node;
        }
        return null;
    }

    private Node getMasterNode(StructureNode structureNode, int structureOffset) {
        for (Node node : structureNode.nodes) {
            if (structureOffset >= node.structureOffset + node.nfields) continue;
            if (!node.isStructure) {
                return node;
            }
            StructureNode subNode = (StructureNode)node;
            return this.getMasterNode(subNode, structureOffset);
        }
        return null;
    }

    private void dump(StringBuilder builder, Node node, int indentLevel) {
        convert.newLine(builder, indentLevel);
        String kind = node.isStructure ? "structureNode" : "node";
        builder.append(kind);
        builder.append(" isStructure " + (node.isStructure ? "true" : "false"));
        builder.append(" structureOffset " + node.structureOffset);
        builder.append(" nfields " + node.nfields);
        PVStructure options = node.options;
        if (options != null) {
            convert.newLine(builder, indentLevel + 1);
            builder.append(options.getFieldName());
            PVField[] pvFields = options.getPVFields();
            for (int i = 0; i < pvFields.length; ++i) {
                PVString pvString = (PVString)pvFields[i];
                convert.newLine(builder, indentLevel + 2);
                builder.append(pvString.getFieldName() + " " + pvString.get());
            }
        }
        String name = node.masterPVField.getFullName();
        convert.newLine(builder, indentLevel + 1);
        builder.append("masterField name " + name);
        if (!node.isStructure) {
            return;
        }
        StructureNode structureNode = (StructureNode)node;
        Node[] nodes = structureNode.nodes;
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) {
                convert.newLine(builder, indentLevel + 1);
                builder.append("node[" + i + "] is null");
                continue;
            }
            this.dump(builder, nodes[i], indentLevel + 1);
        }
    }

    static class StructureNode
    extends Node {
        Node[] nodes;

        StructureNode() {
        }
    }

    static class Node {
        PVField masterPVField;
        boolean isStructure = false;
        int structureOffset = 0;
        int nfields = 0;
        PVStructure options = null;

        Node() {
        }
    }
}

