/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.copy;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.Structure;

public class CreateRequest {
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private static final FieldCreate fieldCreate = FieldFactory.getFieldCreate();
    private static final Structure emptyStructure = fieldCreate.createStructure(new String[0], new Field[0]);
    private static final Pattern commaPattern = Pattern.compile("[,]");
    private static final Pattern equalPattern = Pattern.compile("[=]");
    private String message;
    private List<OptionPair> optionList = new ArrayList<OptionPair>();
    private String fullFieldName = "";

    public static CreateRequest create() {
        return new CreateRequest();
    }

    public PVStructure createRequest(String request) {
        return this.createRequestInternal(request);
    }

    public String getMessage() {
        return this.message;
    }

    private PVStructure createRequestInternal(String request) {
        try {
            this.message = "";
            this.fullFieldName = "";
            this.optionList.clear();
            if (request != null) {
                request = request.replaceAll("\\s+", "");
            }
            if (request == null || request.length() <= 0) {
                PVStructure pvStructure = pvDataCreate.createPVStructure(emptyStructure);
                return pvStructure;
            }
            int offsetRecord = request.indexOf("record[");
            int offsetField = request.indexOf("field(");
            int offsetPutField = request.indexOf("putField(");
            int offsetGetField = request.indexOf("getField(");
            if (offsetRecord == -1 && offsetField == -1 && offsetPutField == -1 && offsetGetField == -1) {
                request = "field(" + request + ")";
                offsetField = request.indexOf("field(");
            }
            int numParan = 0;
            int numBrace = 0;
            int numBracket = 0;
            for (int i = 0; i < request.length(); ++i) {
                char chr = request.charAt(i);
                if (chr == '(') {
                    ++numParan;
                }
                if (chr == ')') {
                    --numParan;
                }
                if (chr == '{') {
                    ++numBrace;
                }
                if (chr == '}') {
                    --numBrace;
                }
                if (chr == '[') {
                    ++numBracket;
                }
                if (chr != ']') continue;
                --numBracket;
            }
            if (numParan != 0) {
                this.message = "mismatched () " + numParan;
                return null;
            }
            if (numBrace != 0) {
                this.message = "mismatched {} " + numBrace;
                return null;
            }
            if (numBracket != 0) {
                this.message = "mismatched [] " + numBracket;
                return null;
            }
            ArrayList<Node> top = new ArrayList<Node>();
            try {
                String req;
                int openParan;
                if (offsetRecord >= 0) {
                    this.fullFieldName = "record";
                    int openBracket = request.indexOf(91, offsetRecord);
                    int closeBracket = request.indexOf(93, openBracket);
                    if (closeBracket == -1) {
                        this.message = request.substring(offsetRecord) + "record[ does not have matching ]";
                        return null;
                    }
                    if (closeBracket - openBracket > 3) {
                        Node node = new Node("record");
                        Node optNode = this.createRequestOptions(request.substring(openBracket + 1, closeBracket));
                        node.nodes.add(optNode);
                        top.add(node);
                    }
                }
                if (offsetField >= 0) {
                    this.fullFieldName = "field";
                    Node node = new Node("field");
                    openParan = request.indexOf(40, offsetField);
                    int closeParan = request.indexOf(41, openParan);
                    if (closeParan == -1) {
                        this.message = request.substring(offsetField) + " field( does not have matching )";
                        return null;
                    }
                    if (closeParan > openParan + 1) {
                        req = request.substring(openParan + 1, closeParan);
                        req = this.createTopOption(node, req);
                        this.createSubNode(node, req);
                    }
                    top.add(node);
                }
                if (offsetGetField >= 0) {
                    this.fullFieldName = "getField";
                    Node node = new Node("getField");
                    openParan = request.indexOf(40, offsetGetField);
                    int closeParan = request.indexOf(41, openParan);
                    if (closeParan == -1) {
                        this.message = request.substring(offsetField) + " getField( does not have matching )";
                        return null;
                    }
                    if (closeParan > openParan + 1) {
                        req = request.substring(openParan + 1, closeParan);
                        req = this.createTopOption(node, req);
                        this.createSubNode(node, req);
                    }
                    top.add(node);
                }
                if (offsetPutField >= 0) {
                    this.fullFieldName = "putField";
                    Node node = new Node("putField");
                    openParan = request.indexOf(40, offsetPutField);
                    int closeParan = request.indexOf(41, openParan);
                    if (closeParan == -1) {
                        this.message = request.substring(offsetField) + " putField( does not have matching )";
                        return null;
                    }
                    if (closeParan > openParan + 1) {
                        req = request.substring(openParan + 1, closeParan);
                        req = this.createTopOption(node, req);
                        this.createSubNode(node, req);
                    }
                    top.add(node);
                }
            }
            catch (IllegalStateException e) {
                this.message = "while creating Structure exception " + e.getMessage();
                return null;
            }
            int num = top.size();
            Field[] fields = new Field[num];
            String[] names = new String[num];
            for (int i = 0; i < num; ++i) {
                Node node = (Node)top.get(i);
                names[i] = node.name;
                List<Node> subNode = node.nodes;
                fields[i] = subNode.isEmpty() ? emptyStructure : this.createSubStructure(subNode);
            }
            Structure structure = fieldCreate.createStructure(names, fields);
            PVStructure pvStructure = pvDataCreate.createPVStructure(structure);
            for (OptionPair pair : this.optionList) {
                String name = pair.name;
                String value = pair.value;
                PVString pvField = pvStructure.getSubField(PVString.class, name);
                pvField.put(value);
            }
            this.optionList.clear();
            return pvStructure;
        }
        catch (Exception e) {
            this.message = e.getMessage();
            return null;
        }
    }

    private int findMatchingBrace(String request, int index, int numOpen) {
        int openBrace = request.indexOf(123, index + 1);
        int closeBrace = request.indexOf(125, index + 1);
        if (openBrace == -1 && closeBrace == -1) {
            String message = "mismatched {} " + request;
            throw new IllegalStateException(message);
        }
        if (openBrace > 0) {
            if (openBrace < closeBrace) {
                return this.findMatchingBrace(request, openBrace, numOpen + 1);
            }
            if (numOpen == 1) {
                return closeBrace;
            }
            return this.findMatchingBrace(request, closeBrace, numOpen - 1);
        }
        if (numOpen == 1) {
            return closeBrace;
        }
        return this.findMatchingBrace(request, closeBrace, numOpen - 1);
    }

    private int findMatchingBracket(String request, int index) {
        for (int i = index + 1; i < request.length(); ++i) {
            if (request.charAt(i) != ']') continue;
            if (i == index + 1) {
                this.message = " mismatched [ ]" + this.message;
                throw new IllegalStateException(this.message);
            }
            return i;
        }
        this.message = " missing ]" + request;
        throw new IllegalStateException(this.message);
    }

    private int findEndField(String request) {
        int ind = 0;
        int maxind = request.length() - 1;
        while (true) {
            if (request.charAt(ind) == ',') {
                return ind;
            }
            if (request.charAt(ind) == '[') {
                int closeBracket = this.findMatchingBracket(request, ind);
                if (closeBracket == -1) {
                    return closeBracket;
                }
                ind = closeBracket;
                continue;
            }
            if (request.charAt(ind) == '{') {
                int closeBrace = this.findMatchingBrace(request, ind, 1);
                if (ind >= request.length()) {
                    return request.length();
                }
                ind = closeBrace;
                continue;
            }
            if (request.charAt(ind) == '.') {
                ++ind;
                continue;
            }
            if (ind >= maxind) break;
            ++ind;
        }
        return request.length();
    }

    private Node createRequestOptions(String request) {
        if (request.length() <= 1) {
            throw new IllegalStateException("logic error empty options");
        }
        ArrayList<Node> top = new ArrayList<Node>();
        String[] items = commaPattern.split(request);
        int nitems = items.length;
        for (int j = 0; j < nitems; ++j) {
            String[] names = equalPattern.split(items[j]);
            if (names.length != 2) {
                this.message = "illegal option " + request;
                throw new IllegalStateException(this.message);
            }
            Node node = new Node(names[0]);
            String name = this.fullFieldName + "._options." + names[0];
            String value = names[1];
            this.optionList.add(new OptionPair(name, value));
            top.add(node);
        }
        Node node = new Node("_options");
        node.nodes = top;
        return node;
    }

    private String createTopOption(Node node, String request) {
        int length = request.length();
        if (length <= 0) {
            return request;
        }
        char open = request.charAt(0);
        if (open != '[') {
            return request;
        }
        int end = 0;
        for (int i = 0; i < length; ++i) {
            char chr = request.charAt(i);
            if (chr != ']') continue;
            end = i;
            break;
        }
        if (end == 0) {
            return request;
        }
        String options = request.substring(1, end);
        Node optionNode = this.createRequestOptions(options);
        if (optionNode == null) {
            return request;
        }
        node.nodes.add(optionNode);
        if (end + 1 < length && request.charAt(end + 1) == ',') {
            ++end;
        }
        return request.substring(end + 1);
    }

    private void createSubNode(Node node, String request) {
        Node subNode;
        String name;
        int end = 0;
        for (int i = 0; i < request.length(); ++i) {
            char chr = request.charAt(i);
            if (chr == '[') {
                end = i;
                break;
            }
            if (chr == '.') {
                end = i;
                break;
            }
            if (chr == '{') {
                end = i;
                break;
            }
            if (chr != ',') continue;
            end = i;
            break;
        }
        char chr = request.charAt(end);
        Node optionNode = null;
        if (chr == '[') {
            String saveFullName = this.fullFieldName;
            this.fullFieldName = this.fullFieldName + "." + request.substring(0, end);
            int endBracket = this.findMatchingBracket(request, end);
            String options = request.substring(end + 1, endBracket);
            optionNode = this.createRequestOptions(options);
            this.fullFieldName = saveFullName;
            int next = endBracket + 1;
            request = next < request.length() ? request.substring(0, end) + request.substring(endBracket + 1) : request.substring(0, end);
            end = 0;
            for (int i = 0; i < request.length(); ++i) {
                chr = request.charAt(i);
                if (chr == '.') {
                    end = i;
                    break;
                }
                if (chr == '{') {
                    end = i;
                    break;
                }
                if (chr != ',') continue;
                end = i;
                break;
            }
        }
        if (end == 0) {
            end = request.length();
        }
        if ((name = request.substring(0, end)).length() < 1) {
            this.message = "null field name " + request;
            throw new IllegalStateException(this.message);
        }
        String saveFullName = this.fullFieldName;
        this.fullFieldName = this.fullFieldName + "." + name;
        if (end == request.length()) {
            subNode = new Node(name);
            if (optionNode != null) {
                subNode.nodes.add(optionNode);
            }
            node.nodes.add(subNode);
            this.fullFieldName = saveFullName;
            return;
        }
        if (chr == ',') {
            subNode = new Node(name);
            if (optionNode != null) {
                subNode.nodes.add(optionNode);
            }
            node.nodes.add(subNode);
            String rest = request.substring(end + 1);
            this.fullFieldName = saveFullName;
            this.createSubNode(node, rest);
            return;
        }
        if (chr == '.') {
            if ((request = request.substring(end + 1)).length() < 1) {
                this.message = "null field name " + request;
                throw new IllegalStateException(this.message);
            }
            subNode = new Node(name);
            if (optionNode != null) {
                subNode.nodes.add(optionNode);
            }
            int endField = this.findEndField(request);
            String subRequest = request.substring(0, endField);
            this.createSubNode(subNode, subRequest);
            node.nodes.add(subNode);
            int next = endField + 1;
            if (next >= request.length()) {
                this.fullFieldName = saveFullName;
                return;
            }
            request = request.substring(next);
            this.fullFieldName = saveFullName;
            this.createSubNode(node, request);
            return;
        }
        if (chr == '{') {
            int endBrace = this.findEndField(request);
            if (end + 1 >= endBrace - 1) {
                this.message = " illegal syntax " + request;
                throw new IllegalStateException(this.message);
            }
            String subRequest = request.substring(end + 1, endBrace - 1);
            if (subRequest.length() < 1) {
                this.message = " empty {} " + request;
                throw new IllegalStateException(this.message);
            }
            Node subNode2 = new Node(name);
            if (optionNode != null) {
                subNode2.nodes.add(optionNode);
            }
            this.createSubNode(subNode2, subRequest);
            node.nodes.add(subNode2);
            int next = endBrace + 1;
            if (next >= request.length()) {
                this.fullFieldName = saveFullName;
                return;
            }
            request = request.substring(next);
            this.fullFieldName = saveFullName;
            this.createSubNode(node, request);
            return;
        }
        this.message = "logic error";
        throw new IllegalStateException(this.message);
    }

    private Field createSubStructure(List<Node> nodes) {
        int num = nodes.size();
        Field[] fields = new Field[num];
        String[] names = new String[num];
        for (int i = 0; i < num; ++i) {
            List<Node> subNode;
            Node node = nodes.get(i);
            names[i] = node.name;
            fields[i] = node.name.equals("_options") ? this.createOptions(node.nodes) : ((subNode = node.nodes).isEmpty() ? emptyStructure : this.createSubStructure(subNode));
        }
        Structure structure = fieldCreate.createStructure(names, fields);
        return structure;
    }

    private Structure createOptions(List<Node> nodes) {
        int num = nodes.size();
        Field[] fields = new Field[num];
        String[] names = new String[num];
        for (int i = 0; i < num; ++i) {
            Node node = nodes.get(i);
            names[i] = node.name;
            fields[i] = fieldCreate.createScalar(ScalarType.pvString);
        }
        Structure structure = fieldCreate.createStructure(names, fields);
        return structure;
    }

    private class OptionPair {
        String name;
        String value;

        OptionPair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private class Node {
        String name;
        List<Node> nodes = new ArrayList<Node>();

        Node(String name) {
            this.name = name;
        }
    }
}

