/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.util.configuration.impl;

import org.epics.pvaccess.util.configuration.Configuration;

public class SystemConfigurationImpl
implements Configuration {
    @Override
    public boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        boolean isFalse;
        boolean isTrue;
        String value = this.getPropertyAsString(name, String.valueOf(defaultValue));
        boolean bl = isTrue = (value = value.toLowerCase()).equals("1") || value.equals("true") || value.equals("yes");
        if (isTrue) {
            return true;
        }
        boolean bl2 = isFalse = value.equals("0") || value.equals("false") || value.equals("no");
        if (isFalse) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public int getPropertyAsInteger(String name, int defaultValue) {
        String val = this.getPropertyAsString(name, null);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    @Override
    public float getPropertyAsFloat(String name, float defaultValue) {
        String val = this.getPropertyAsString(name, null);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(val);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    @Override
    public String getPropertyAsString(String name, String defaultValue) {
        String sysEnv = System.getenv(name);
        if (sysEnv != null) {
            defaultValue = sysEnv;
        }
        return System.getProperty(name, defaultValue);
    }
}

