/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.util.configuration.impl;

import java.util.HashMap;
import org.epics.pvaccess.util.configuration.Configuration;
import org.epics.pvaccess.util.configuration.ConfigurationProvider;
import org.epics.pvaccess.util.configuration.impl.SystemConfigurationImpl;

public class ConfigurationFactory {
    private static ConfigurationProvider provider;

    public static synchronized ConfigurationProvider getProvider() {
        if (provider == null) {
            provider = new ConfigurationProviderImpl();
            provider.registerConfiguration("system", new SystemConfigurationImpl());
        }
        return provider;
    }

    private static class ConfigurationProviderImpl
    implements ConfigurationProvider {
        private HashMap<String, Configuration> configs = new HashMap();

        private ConfigurationProviderImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerConfiguration(String name, Configuration configuration) {
            HashMap<String, Configuration> hashMap = this.configs;
            synchronized (hashMap) {
                if (this.configs.containsKey(name)) {
                    throw new IllegalStateException("configuration with name " + name + " already registered");
                }
                this.configs.put(name, configuration);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Configuration getConfiguration(String name) {
            HashMap<String, Configuration> hashMap = this.configs;
            synchronized (hashMap) {
                return this.configs.get(name);
            }
        }
    }
}

