/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.util;

public class WildcharMatcher {
    private static final int INITIAL = 0;
    private static final int FINAL = 2;
    private static final int ERROR = 99;
    private static final int TOKEN_CHAR = 0;
    private static final int TOKEN_END = 1;
    private static final int TOKEN_NOT = 2;
    private static final int TOKEN_MINUS = 3;
    private static final int[][] TRANSITIONS = new int[][]{{1, 2, 3, 4}, {1, 2, 99, 5}, {99, 99, 99, 99}, {1, 2, 99, 4}, {6, 99, 99, 99}, {6, 2, 99, 99}, {1, 2, 99, 99}};

    private static int getToken(char ch) {
        switch (ch) {
            case ']': {
                return 1;
            }
            case '!': {
                return 2;
            }
            case '-': {
                return 3;
            }
        }
        return 0;
    }

    public static boolean testSet(String pattern, int offset, char ch) {
        int n = pattern.length();
        int state = 0;
        int nextToken = 32;
        char nextChar = ' ';
        char ch1 = ' ';
        boolean found = false;
        boolean negate = false;
        while (!found) {
            if (offset < n) {
                nextChar = pattern.charAt(offset);
                if (nextChar == '\\') {
                    nextChar = pattern.charAt(offset + 1);
                    nextToken = 0;
                    ++offset;
                } else {
                    nextToken = WildcharMatcher.getToken(nextChar);
                }
            }
            switch (state) {
                case 0: {
                    if (nextToken == 2) {
                        negate = true;
                        break;
                    }
                }
                case 1: {
                    if (nextToken == 1) {
                        return true;
                    }
                }
                case 3: 
                case 6: {
                    if (nextToken != 0) break;
                    found = ch == nextChar;
                    ch1 = nextChar;
                    break;
                }
                case 4: {
                    found = ch <= nextChar;
                    break;
                }
                case 5: {
                    if (nextToken == 0) {
                        boolean bl = found = ch >= ch1 && ch <= nextChar;
                    }
                    if (nextToken != 1) break;
                    found = ch >= ch1;
                    break;
                }
            }
            state = TRANSITIONS[state][nextToken];
            if (state == 99) {
                return false;
            }
            if (state == 2) {
                return found ^ negate;
            }
            ++offset;
        }
        return found ^ negate;
    }

    public static boolean parse(String pattern, int ofp, String str, int ofs) {
        int lp = pattern.length();
        int ls = str.length();
        int ip = ofp;
        int is = ofs;
        block5: while (ip < lp) {
            char chp = pattern.charAt(ip);
            switch (chp) {
                case '[': {
                    boolean isWildchar;
                    int end = pattern.indexOf("]", ip);
                    if (end == -1) {
                        return false;
                    }
                    boolean bl = isWildchar = end + 1 < lp && pattern.charAt(end + 1) == '*';
                    if (is >= ls) {
                        return WildcharMatcher.parse(pattern, end + 2, str, is);
                    }
                    char chs = str.charAt(is);
                    boolean thisChar = WildcharMatcher.testSet(pattern, ip + 1, chs);
                    if (!thisChar && !isWildchar) {
                        return false;
                    }
                    if (isWildchar) {
                        if (!thisChar) {
                            ip = end + 2;
                            continue block5;
                        }
                        if (WildcharMatcher.parse(pattern, end + 2, str, is)) {
                            return true;
                        }
                        if (WildcharMatcher.parse(pattern, ip, str, is + 1)) {
                            return true;
                        }
                    }
                    ip = end + 1;
                    ++is;
                    continue block5;
                }
                case '?': {
                    ++ip;
                    ++is;
                    continue block5;
                }
                case '*': {
                    if (ip + 1 == lp) {
                        return true;
                    }
                    do {
                        chp = pattern.charAt(++ip);
                    } while (ip + 1 < lp && chp == '*');
                    if (chp == '?' && WildcharMatcher.parse(pattern, ip, str, is)) {
                        return true;
                    }
                    for (int i = is; i < ls; ++i) {
                        if (!WildcharMatcher.parse(pattern, ip, str, i)) continue;
                        return true;
                    }
                    continue block5;
                }
            }
            if (is == ls || pattern.charAt(ip) != str.charAt(is)) {
                return false;
            }
            ++ip;
            ++is;
        }
        while (ip < lp && pattern.charAt(ip) == '*') {
            ++ip;
        }
        return is == ls && ip == lp;
    }

    public static boolean match(String pattern, String str) {
        return WildcharMatcher.parse(pattern, 0, str, 0);
    }
}

