/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.util;

public final class GrowingCircularBuffer<T> {
    private T[] elements;
    private int takePointer = 0;
    private int putPointer = 0;
    private int count = 0;

    public GrowingCircularBuffer(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.elements = new Object[capacity];
    }

    public int size() {
        return this.count;
    }

    public int capacity() {
        return this.elements.length;
    }

    public final boolean insert(T x) {
        if (this.count == this.elements.length) {
            Object[] newElements = new Object[this.elements.length * 2];
            int split = this.elements.length - this.takePointer;
            if (split > 0) {
                System.arraycopy(this.elements, this.takePointer, newElements, 0, split);
            }
            if (this.takePointer != 0) {
                System.arraycopy(this.elements, 0, newElements, split, this.putPointer);
            }
            this.takePointer = 0;
            this.putPointer = this.elements.length;
            this.elements = newElements;
        }
        ++this.count;
        this.elements[this.putPointer] = x;
        if (++this.putPointer >= this.elements.length) {
            this.putPointer = 0;
        }
        return this.count == 1;
    }

    public final T extract() {
        if (this.count == 0) {
            return null;
        }
        --this.count;
        T old = this.elements[this.takePointer];
        this.elements[this.takePointer] = null;
        if (++this.takePointer >= this.elements.length) {
            this.takePointer = 0;
        }
        return old;
    }
}

