/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.util;

public final class CircularBuffer<T> {
    private final T[] elements;
    private int takePointer = 0;
    private int putPointer = 0;
    private int count = 0;

    public CircularBuffer(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.elements = new Object[capacity];
    }

    public int size() {
        return this.count;
    }

    public int capacity() {
        return this.elements.length;
    }

    public final T insert(T x) {
        if (this.count < this.elements.length) {
            ++this.count;
        } else if (++this.takePointer >= this.elements.length) {
            this.takePointer = 0;
        }
        T old = this.elements[this.putPointer];
        this.elements[this.putPointer] = x;
        if (++this.putPointer >= this.elements.length) {
            this.putPointer = 0;
        }
        return old;
    }

    public final T extract() {
        if (this.count == 0) {
            return null;
        }
        --this.count;
        T old = this.elements[this.takePointer];
        this.elements[this.takePointer] = null;
        if (++this.takePointer >= this.elements.length) {
            this.takePointer = 0;
        }
        return old;
    }
}

