/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.rpc.impl;

import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.epics.pvaccess.client.AccessRights;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelArray;
import org.epics.pvaccess.client.ChannelArrayRequester;
import org.epics.pvaccess.client.ChannelGet;
import org.epics.pvaccess.client.ChannelGetRequester;
import org.epics.pvaccess.client.ChannelProcess;
import org.epics.pvaccess.client.ChannelProcessRequester;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelPut;
import org.epics.pvaccess.client.ChannelPutGet;
import org.epics.pvaccess.client.ChannelPutGetRequester;
import org.epics.pvaccess.client.ChannelPutRequester;
import org.epics.pvaccess.client.ChannelRPC;
import org.epics.pvaccess.client.ChannelRPCRequester;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvaccess.client.GetFieldRequester;
import org.epics.pvaccess.server.rpc.RPCRequestException;
import org.epics.pvaccess.server.rpc.RPCResponseCallback;
import org.epics.pvaccess.server.rpc.RPCService;
import org.epics.pvaccess.server.rpc.RPCServiceAsync;
import org.epics.pvaccess.server.rpc.Service;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.monitor.Monitor;
import org.epics.pvdata.monitor.MonitorRequester;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class RPCChannel
implements Channel {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private static final Status notSupportedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "only channelRPC requests are supported by this channel", null);
    private static final Status destroyedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "channel destroyed", null);
    private static final Status okStatus = statusCreate.getStatusOK();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final ArrayList<ChannelRPC> channelRPCRequests = new ArrayList();
    private final ChannelProvider provider;
    private final String channelName;
    private final ChannelRequester channelRequester;
    private final Service service;
    private final ThreadPoolExecutor threadPool;

    public RPCChannel(ChannelProvider provider, String channelName, ChannelRequester channelRequester, Service service, ThreadPoolExecutor threadPool) {
        this.provider = provider;
        this.channelName = channelName;
        this.channelRequester = channelRequester;
        this.service = service;
        this.threadPool = threadPool;
    }

    @Override
    public ChannelProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public ChannelRequester getChannelRequester() {
        return this.channelRequester;
    }

    @Override
    public String getRemoteAddress() {
        return this.getChannelName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (!this.destroyed.getAndSet(true)) {
            ArrayList<ChannelRPC> arrayList = this.channelRPCRequests;
            synchronized (arrayList) {
                int size;
                while ((size = this.channelRPCRequests.size()) > 0) {
                    this.channelRPCRequests.get(size - 1).destroy();
                }
            }
        }
    }

    @Override
    public boolean isConnected() {
        return !this.destroyed.get();
    }

    @Override
    public Channel.ConnectionState getConnectionState() {
        return this.isConnected() ? Channel.ConnectionState.CONNECTED : Channel.ConnectionState.DESTROYED;
    }

    @Override
    public ChannelRPC createChannelRPC(ChannelRPCRequester channelRPCRequester, PVStructure pvRequest) {
        if (channelRPCRequester == null) {
            throw new IllegalArgumentException("channelRPCRequester == null");
        }
        if (this.destroyed.get()) {
            channelRPCRequester.channelRPCConnect(destroyedStatus, null);
            return null;
        }
        ChannelRPCImpl channelRPCImpl = new ChannelRPCImpl(this, channelRPCRequester);
        channelRPCRequester.channelRPCConnect(okStatus, channelRPCImpl);
        return channelRPCImpl;
    }

    @Override
    public AccessRights getAccessRights(PVField pvField) {
        return AccessRights.none;
    }

    @Override
    public void getField(GetFieldRequester requester, String subField) {
        requester.getDone(notSupportedStatus, null);
    }

    @Override
    public ChannelProcess createChannelProcess(ChannelProcessRequester channelProcessRequester, PVStructure pvRequest) {
        channelProcessRequester.channelProcessConnect(notSupportedStatus, null);
        return null;
    }

    @Override
    public ChannelGet createChannelGet(ChannelGetRequester channelGetRequester, PVStructure pvRequest) {
        channelGetRequester.channelGetConnect(notSupportedStatus, null, null);
        return null;
    }

    @Override
    public ChannelPut createChannelPut(ChannelPutRequester channelPutRequester, PVStructure pvRequest) {
        channelPutRequester.channelPutConnect(notSupportedStatus, null, null);
        return null;
    }

    @Override
    public ChannelPutGet createChannelPutGet(ChannelPutGetRequester channelPutGetRequester, PVStructure pvRequest) {
        channelPutGetRequester.channelPutGetConnect(notSupportedStatus, null, null, null);
        return null;
    }

    @Override
    public Monitor createMonitor(MonitorRequester monitorRequester, PVStructure pvRequest) {
        monitorRequester.monitorConnect(notSupportedStatus, null, null);
        return null;
    }

    @Override
    public ChannelArray createChannelArray(ChannelArrayRequester channelArrayRequester, PVStructure pvRequest) {
        channelArrayRequester.channelArrayConnect(notSupportedStatus, null, null);
        return null;
    }

    public String getRequesterName() {
        return this.getChannelName();
    }

    public void message(String message, MessageType messageType) {
        this.channelRequester.message(message, messageType);
    }

    private class ChannelRPCImpl
    implements ChannelRPC,
    RPCResponseCallback {
        private final ChannelRPCRequester channelRPCRequester;
        private final Channel channel;
        private volatile boolean lastRequest = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelRPCImpl(Channel channel, ChannelRPCRequester channelRPCRequester) {
            this.channel = channel;
            this.channelRPCRequester = channelRPCRequester;
            ArrayList arrayList = RPCChannel.this.channelRPCRequests;
            synchronized (arrayList) {
                RPCChannel.this.channelRPCRequests.add(this);
            }
        }

        @Override
        public void lastRequest() {
            this.lastRequest = true;
        }

        @Override
        public Channel getChannel() {
            return this.channel;
        }

        private void processRequest(RPCService rpcService, PVStructure pvArgument) {
            PVStructure result = null;
            Status status = okStatus;
            boolean ok = true;
            try {
                result = rpcService.request(pvArgument);
            }
            catch (RPCRequestException rre) {
                status = statusCreate.createStatus(rre.getStatus(), rre.getMessage(), (Throwable)rre);
                ok = false;
            }
            catch (Throwable th) {
                status = statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught while calling RPCService.request(PVStructure).", th);
                ok = false;
            }
            if (ok && result == null) {
                status = statusCreate.createStatus(Status.StatusType.FATAL, "RPCService.request(PVStructure) returned null.", null);
            }
            this.channelRPCRequester.requestDone(status, this, result);
            if (this.lastRequest) {
                this.destroy();
            }
        }

        @Override
        public void requestDone(Status status, PVStructure result) {
            this.channelRPCRequester.requestDone(status, this, result);
            if (this.lastRequest) {
                this.destroy();
            }
        }

        private void processRequest(RPCServiceAsync rpcServiceAsync, PVStructure pvArgument) {
            block2: {
                try {
                    rpcServiceAsync.request(pvArgument, this);
                }
                catch (Throwable th) {
                    Status status = statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught while calling RPCService.request(PVStructure).", th);
                    this.channelRPCRequester.requestDone(status, this, null);
                    if (!this.lastRequest) break block2;
                    this.destroy();
                }
            }
        }

        @Override
        public void request(final PVStructure pvArgument) {
            if (RPCChannel.this.service instanceof RPCService) {
                final RPCService rpcService = (RPCService)RPCChannel.this.service;
                if (RPCChannel.this.threadPool == null) {
                    this.processRequest(rpcService, pvArgument);
                } else {
                    RPCChannel.this.threadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            ChannelRPCImpl.this.processRequest(rpcService, pvArgument);
                        }
                    });
                }
            } else if (RPCChannel.this.service instanceof RPCServiceAsync) {
                RPCServiceAsync rpcServiceAsync = (RPCServiceAsync)RPCChannel.this.service;
                this.processRequest(rpcServiceAsync, pvArgument);
            } else {
                throw new RuntimeException("unsupported Service type");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            ArrayList arrayList = RPCChannel.this.channelRPCRequests;
            synchronized (arrayList) {
                RPCChannel.this.channelRPCRequests.remove(this);
            }
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        @Override
        public void cancel() {
        }
    }
}

