/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.rpc;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.epics.pvaccess.PVAException;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.plugins.DefaultBeaconServerDataProvider;
import org.epics.pvaccess.server.rpc.RPCService;
import org.epics.pvaccess.server.rpc.RPCServiceAsync;
import org.epics.pvaccess.server.rpc.impl.RPCChannelProvider;

public class RPCServer {
    private final ServerContextImpl serverContext;
    private final RPCChannelProvider channelProviderImpl;
    private final ThreadPoolExecutor threadPoll;

    public RPCServer() {
        this(0, 1);
    }

    public RPCServer(int threads, int queueSize) {
        if (threads < 0) {
            throw new IllegalArgumentException("threads < 0");
        }
        if (threads > 0 && queueSize < 1) {
            throw new IllegalArgumentException("queueSize < 1");
        }
        if (threads > 0) {
            this.threadPoll = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize));
            this.threadPoll.prestartAllCoreThreads();
        } else {
            this.threadPoll = null;
        }
        this.channelProviderImpl = new RPCChannelProvider(this.threadPoll);
        this.serverContext = new ServerContextImpl();
        this.serverContext.setBeaconServerStatusProvider(new DefaultBeaconServerDataProvider(this.serverContext));
        try {
            this.serverContext.initialize(this.channelProviderImpl);
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to initialize pvAccess RPC server.", th);
        }
    }

    public void printInfo() {
        System.out.println(this.serverContext.getVersion().getVersionString());
        this.serverContext.printInfo();
    }

    public void run(int seconds) throws PVAException {
        this.serverContext.run(seconds);
    }

    public void destroy() throws PVAException {
        if (this.threadPoll == null) {
            this.serverContext.destroy();
        } else {
            this.threadPoll.shutdown();
            this.serverContext.destroy();
            this.threadPoll.shutdownNow();
        }
    }

    public void registerService(String serviceName, RPCService service) {
        this.channelProviderImpl.registerService(serviceName, service);
    }

    public void registerService(String serviceName, RPCServiceAsync service) {
        this.channelProviderImpl.registerService(serviceName, service);
    }

    public void unregisterService(String serviceName) {
        this.channelProviderImpl.unregisterService(serviceName);
    }
}

