/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.plugins;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.plugins.BeaconServerStatusProvider;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;

public class DefaultBeaconServerDataProvider
implements BeaconServerStatusProvider {
    protected ServerContextImpl context;
    protected PVStructure status;

    public DefaultBeaconServerDataProvider(ServerContextImpl context) {
        this.context = context;
        this.initialize();
    }

    private void initialize() {
        FieldCreate fieldCreate = PVFactory.getFieldCreate();
        PVDataCreate pvDataCreate = PVFactory.getPVDataCreate();
        String[] fieldNames = new String[]{"connections", "allocatedMemory", "freeMemory", "threads", "deadlocks", "averageSystemLoad"};
        Field[] fields = new Field[]{fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvLong), fieldCreate.createScalar(ScalarType.pvLong), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvDouble)};
        this.status = pvDataCreate.createPVStructure(fieldCreate.createStructure(fieldNames, fields));
    }

    @Override
    public PVField getServerStatusData() {
        this.status.getIntField("connections").put(this.context.getTransportRegistry().numberOfActiveTransports());
        this.status.getLongField("allocatedMemory").put(Runtime.getRuntime().totalMemory());
        this.status.getLongField("freeMemory").put(Runtime.getRuntime().freeMemory());
        ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();
        this.status.getIntField("threads").put(threadMBean.getThreadCount());
        long[] deadlocks = threadMBean.isSynchronizerUsageSupported() ? threadMBean.findDeadlockedThreads() : threadMBean.findMonitorDeadlockedThreads();
        this.status.getIntField("deadlocks").put(deadlocks != null ? deadlocks.length : 0);
        OperatingSystemMXBean osMBean = ManagementFactory.getOperatingSystemMXBean();
        this.status.getDoubleField("averageSystemLoad").put(osMBean.getSystemLoadAverage());
        return this.status;
    }
}

