/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvaccess.client.ChannelFind;
import org.epics.pvaccess.client.ChannelFindRequester;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.impl.remote.ProtocolType;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.udp.BlockingUDPTransport;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.util.InetAddressUtil;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.misc.Timer;
import org.epics.pvdata.misc.TimerFactory;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class SearchHandler
extends AbstractServerResponseHandler {
    private final ChannelFindRequesterImplObjectPool objectPool = new ChannelFindRequesterImplObjectPool();
    private final Random random = new Random();
    private static final int MAX_SERVER_SEARCH_RESPONSE_DELAY_MS = 100;
    private static final String SUPPORTED_PROTOCOL = ProtocolType.tcp.name();

    public SearchHandler(ServerContextImpl context) {
        super(context, "Search request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        BlockingUDPTransport bt;
        InetAddress addr;
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        transport.ensureData(26);
        int startPosition = payloadBuffer.position();
        final int searchSequenceId = payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        payloadBuffer.get();
        payloadBuffer.getShort();
        byte[] byteAddress = new byte[16];
        payloadBuffer.get(byteAddress);
        int port = payloadBuffer.getShort() & 0xFFFF;
        try {
            addr = InetAddress.getByAddress(byteAddress);
        }
        catch (UnknownHostException e) {
            this.context.getLogger().log(Level.FINER, "Invalid address '" + new String(byteAddress) + "' in search response received from: " + responseFrom, e);
            return;
        }
        responseFrom = !addr.isAnyLocalAddress() ? new InetSocketAddress(addr, port) : new InetSocketAddress(responseFrom.getAddress(), port);
        if ((qosCode & 0x80) == 128 && (bt = this.context.getLocalMulticastTransport()) != null) {
            payloadBuffer.put(startPosition + 4, (byte)(qosCode & 0xFFFFFF7F));
            payloadBuffer.position(startPosition + 8);
            InetAddressUtil.encodeAsIPv6Address(payloadBuffer, responseFrom.getAddress());
            payloadBuffer.position(payloadBuffer.limit());
            bt.send(payloadBuffer);
            return;
        }
        int protocolsCount = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
        boolean allowed = protocolsCount == 0;
        for (int i = 0; i < protocolsCount; ++i) {
            String protocol = SerializeHelper.deserializeString((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
            if (!SUPPORTED_PROTOCOL.equals(protocol)) continue;
            allowed = true;
        }
        transport.ensureData(2);
        int count = payloadBuffer.getShort() & 0xFFFF;
        boolean responseRequired = QoS.REPLY_REQUIRED.isSet(qosCode);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                transport.ensureData(4);
                int cid = payloadBuffer.getInt();
                String name = SerializeHelper.deserializeString((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
                if (!allowed) continue;
                List<ChannelProvider> providers = this.context.getChannelProviders();
                ChannelFindRequesterImpl cfri = this.objectPool.get().set(this.context.getLogger(), searchSequenceId, name, cid, responseFrom, responseRequired, providers.size());
                for (ChannelProvider provider : providers) {
                    provider.channelFind(name, cfri);
                }
            }
        } else if (allowed) {
            double delay = (double)this.random.nextInt(100) / 1000.0;
            final InetSocketAddress rf = responseFrom;
            Timer.TimerNode timerNode = TimerFactory.createNode((Timer.TimerCallback)new Timer.TimerCallback(){

                public void timerStopped() {
                }

                public void callback() {
                    SearchHandler.this.objectPool.get().set(SearchHandler.this.context.getLogger(), searchSequenceId, rf).channelFindResult(StatusFactory.getStatusCreate().getStatusOK(), null, false);
                }
            });
            this.context.getTimer().scheduleAfterDelay(timerNode, delay);
        }
    }

    private class ChannelFindRequesterImplObjectPool {
        private final ArrayList<ChannelFindRequesterImpl> elements = new ArrayList();

        private ChannelFindRequesterImplObjectPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelFindRequesterImpl get() {
            ArrayList<ChannelFindRequesterImpl> arrayList = this.elements;
            synchronized (arrayList) {
                int count = this.elements.size();
                if (count == 0) {
                    return new ChannelFindRequesterImpl();
                }
                return this.elements.remove(count - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(ChannelFindRequesterImpl element) {
            element.clear();
            ArrayList<ChannelFindRequesterImpl> arrayList = this.elements;
            synchronized (arrayList) {
                this.elements.add(element);
            }
        }
    }

    private class ChannelFindRequesterImpl
    implements ChannelFindRequester,
    TransportSender {
        private Logger logger;
        private boolean serverSearch;
        private int searchSequenceId;
        private String channelName;
        private int cid;
        private InetSocketAddress sendTo;
        private boolean responseRequired;
        private boolean wasFound;
        private int expectedResponseCount;
        private int responseCount;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            ChannelFindRequesterImpl channelFindRequesterImpl = this;
            synchronized (channelFindRequesterImpl) {
                this.logger = null;
                this.channelName = null;
                this.sendTo = null;
                this.responseCount = 0;
                this.wasFound = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelFindRequesterImpl set(Logger logger, int searchSequenceId, String channelName, int cid, InetSocketAddress sendTo, boolean responseRequired, int expectedResponseCount) {
            ChannelFindRequesterImpl channelFindRequesterImpl = this;
            synchronized (channelFindRequesterImpl) {
                this.serverSearch = false;
                this.searchSequenceId = searchSequenceId;
                this.channelName = channelName;
                this.cid = cid;
                this.sendTo = sendTo;
                this.responseRequired = responseRequired;
                this.expectedResponseCount = expectedResponseCount;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelFindRequesterImpl set(Logger logger, int searchSequenceId, InetSocketAddress sendTo) {
            ChannelFindRequesterImpl channelFindRequesterImpl = this;
            synchronized (channelFindRequesterImpl) {
                this.logger = logger;
                this.serverSearch = true;
                this.searchSequenceId = searchSequenceId;
                this.channelName = null;
                this.cid = 0;
                this.sendTo = sendTo;
                this.responseRequired = true;
                this.expectedResponseCount = 1;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelFindResult(Status status, ChannelFind channelFind, boolean wasFound) {
            ChannelFindRequesterImpl channelFindRequesterImpl = this;
            synchronized (channelFindRequesterImpl) {
                ++this.responseCount;
                if (this.responseCount > this.expectedResponseCount) {
                    if (this.responseCount + 1 == this.expectedResponseCount) {
                        this.logger.fine("More responses received than expected for channel '" + this.channelName + "'!");
                    }
                    return;
                }
                if (this.wasFound && wasFound) {
                    this.logger.fine("Channel '" + this.channelName + "' is hosted by different channel providers!");
                    return;
                }
                if (wasFound || this.responseRequired && this.responseCount == this.expectedResponseCount) {
                    if (wasFound && this.expectedResponseCount > 1) {
                        SearchHandler.this.context.getChannelNameToProviderMap().put(this.channelName, channelFind.getChannelProvider());
                    }
                    this.wasFound = wasFound;
                    SearchHandler.this.context.getBroadcastTransport().enqueueSendRequest(this);
                }
            }
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            control.startMessage((byte)4, 34);
            ChannelFindRequesterImpl channelFindRequesterImpl = this;
            synchronized (channelFindRequesterImpl) {
                buffer.put(SearchHandler.this.context.getGUID());
                buffer.putInt(this.searchSequenceId);
                InetAddressUtil.encodeAsIPv6Address(buffer, SearchHandler.this.context.getServerInetAddress());
                buffer.putShort((short)SearchHandler.this.context.getServerPort());
                SerializeHelper.serializeString((String)SUPPORTED_PROTOCOL, (ByteBuffer)buffer, (SerializableControl)control);
                control.ensureBuffer(1);
                buffer.put(this.wasFound ? (byte)1 : 0);
                if (!this.serverSearch) {
                    buffer.putShort((short)1);
                    buffer.putInt(this.cid);
                } else {
                    buffer.putShort((short)0);
                }
                control.setRecipient(this.sendTo);
            }
            SearchHandler.this.objectPool.put(this);
        }
    }
}

