/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelProcess;
import org.epics.pvaccess.client.ChannelProcessRequester;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class ProcessHandler
extends AbstractServerResponseHandler {
    public ProcessHandler(ServerContextImpl context) {
        super(context, "Process request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(9);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            BaseChannelRequester.sendFailureMessage((byte)16, transport, ioid, qosCode, BaseChannelRequester.badCIDStatus);
            return;
        }
        boolean init = QoS.INIT.isSet(qosCode);
        if (init) {
            PVStructure pvRequest = SerializationHelper.deserializePVRequest(payloadBuffer, transport);
            Status asStatus = channel.getChannelSecuritySession().authorizeCreateChannelProcess(ioid, pvRequest);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)16, transport, ioid, (byte)QoS.INIT.getMaskValue(), asStatus);
                return;
            }
            new ChannelProcessRequesterImpl(this.context, channel, ioid, transport, pvRequest);
        } else {
            Status asStatus;
            boolean lastRequest = QoS.DESTROY.isSet(qosCode);
            ChannelProcessRequesterImpl request = (ChannelProcessRequesterImpl)channel.getRequest(ioid);
            if (request == null) {
                BaseChannelRequester.sendFailureMessage((byte)16, transport, ioid, qosCode, BaseChannelRequester.badIOIDStatus);
                return;
            }
            if (!request.startRequest(qosCode)) {
                BaseChannelRequester.sendFailureMessage((byte)16, transport, ioid, qosCode, BaseChannelRequester.otherRequestPendingStatus);
                return;
            }
            ChannelProcess channelProcess = request.getChannelProcess();
            if (lastRequest) {
                channelProcess.lastRequest();
            }
            if (!(asStatus = channel.getChannelSecuritySession().authorizeProcess(ioid)).isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)16, transport, ioid, qosCode, asStatus);
                if (lastRequest) {
                    request.destroy();
                }
                return;
            }
            channelProcess.process();
        }
    }

    private static class ChannelProcessRequesterImpl
    extends BaseChannelRequester
    implements ChannelProcessRequester,
    TransportSender {
        private volatile ChannelProcess channelProcess;
        private volatile Status status;

        public ChannelProcessRequesterImpl(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport, PVStructure pvRequest) {
            super(context, channel, ioid, transport);
            this.startRequest(QoS.INIT.getMaskValue());
            channel.registerRequest(ioid, this);
            try {
                this.channelProcess = channel.getChannel().createChannelProcess(this, pvRequest);
            }
            catch (Throwable th) {
                BaseChannelRequester.sendFailureMessage((byte)16, transport, ioid, (byte)QoS.INIT.getMaskValue(), statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught: " + th.getMessage(), th));
                this.destroy();
            }
        }

        @Override
        public void channelProcessConnect(Status status, ChannelProcess channelProcess) {
            this.status = status;
            this.channelProcess = channelProcess;
            this.transport.enqueueSendRequest(this);
            if (!status.isSuccess()) {
                this.destroy();
            }
        }

        @Override
        public void processDone(Status status, ChannelProcess channelProcess) {
            this.status = status;
            this.transport.enqueueSendRequest(this);
        }

        public void destroy() {
            this.channel.unregisterRequest(this.ioid);
            this.channel.getChannelSecuritySession().release(this.ioid);
            if (this.channelProcess != null) {
                this.channelProcess.destroy();
            }
        }

        public ChannelProcess getChannelProcess() {
            return this.channelProcess;
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            int request = this.getPendingRequest();
            control.startMessage((byte)16, 5);
            buffer.putInt(this.ioid);
            buffer.put((byte)request);
            this.status.serialize(buffer, (SerializableControl)control);
            this.stopRequest();
            if (QoS.DESTROY.isSet(request)) {
                this.destroy();
            }
        }
    }
}

