/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.misc.Destroyable;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.Status;

public class DestroyRequestHandler
extends AbstractServerResponseHandler {
    public DestroyRequestHandler(ServerContextImpl context) {
        super(context, "Destroy request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(8);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            this.failureResponse(transport, ioid, BaseChannelRequester.badCIDStatus);
            return;
        }
        Destroyable request = channel.getRequest(ioid);
        if (request == null) {
            this.failureResponse(transport, ioid, BaseChannelRequester.badIOIDStatus);
            return;
        }
        request.destroy();
        channel.unregisterRequest(ioid);
    }

    private void failureResponse(Transport transport, int ioid, Status errorStatus) {
        BaseChannelRequester.message(transport, ioid, errorStatus.getMessage(), MessageType.warning);
    }
}

