/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;

public class DestroyChannelHandler
extends AbstractServerResponseHandler {
    public DestroyChannelHandler(ServerContextImpl context) {
        super(context, "Destroy channel request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(8);
        final int sid = payloadBuffer.getInt();
        final int cid = payloadBuffer.getInt();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            if (transport.isOpen()) {
                this.context.getLogger().log(Level.WARNING, "Trying to destroy a channel that no longer exists (SID: " + sid + ", CID: " + cid + ", client: " + responseFrom + ").");
            }
            return;
        }
        channel.destroy();
        casTransport.unregisterChannel(sid);
        transport.enqueueSendRequest(new TransportSender(){

            @Override
            public void send(ByteBuffer buffer, TransportSendControl control) {
                control.startMessage((byte)8, 8);
                buffer.putInt(sid);
                buffer.putInt(cid);
            }

            @Override
            public void lock() {
            }

            @Override
            public void unlock() {
            }
        });
    }
}

