/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Level;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.plugins.SecurityPlugin;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvaccess.server.impl.remote.rpc.ServerRPCService;
import org.epics.pvaccess.server.rpc.impl.RPCChannel;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class CreateChannelHandler
extends AbstractServerResponseHandler {
    private static final String SERVER_CHANNEL_NAME = "server";

    public CreateChannelHandler(ServerContextImpl context) {
        super(context, "Create channel request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        SecurityPlugin.ChannelSecuritySession channelSecuritySession;
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        transport.ensureData(6);
        short count = payloadBuffer.getShort();
        if (count != 1) {
            throw new UnsupportedOperationException("only 1 supported for now");
        }
        int cid = payloadBuffer.getInt();
        String channelName = SerializeHelper.deserializeString((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
        if (channelName == null || channelName.length() == 0) {
            this.context.getLogger().warning("Zero length channel name, disconnecting client: " + transport.getRemoteAddress());
            this.disconnect(transport);
            return;
        }
        if (channelName.length() > 500) {
            this.context.getLogger().warning("Unreasonable channel name length, disconnecting client: " + transport.getRemoteAddress());
            this.disconnect(transport);
            return;
        }
        SecurityPlugin.SecuritySession securitySession = transport.getSecuritySession();
        try {
            channelSecuritySession = securitySession.createChannelSession(channelName);
            if (channelSecuritySession == null) {
                throw new SecurityException("null channelSecuritySession");
            }
        }
        catch (SecurityException se) {
            ChannelRequesterImpl cr = new ChannelRequesterImpl(transport, channelName, cid, null);
            Status asStatus = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "Insufficient rights to create a channel: " + se.getMessage(), (Throwable)se);
            cr.channelCreated(asStatus, null);
            return;
        }
        catch (Throwable th) {
            ChannelRequesterImpl cr = new ChannelRequesterImpl(transport, channelName, cid, null);
            Status asStatus = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "Unexpected exception caught while examining channel creation access rights: " + th.getMessage(), th);
            cr.channelCreated(asStatus, null);
            return;
        }
        ChannelRequesterImpl cr = new ChannelRequesterImpl(transport, channelName, cid, channelSecuritySession);
        if (channelName.equals(SERVER_CHANNEL_NAME)) {
            RPCChannel serverChannel = new RPCChannel(null, SERVER_CHANNEL_NAME, cr, new ServerRPCService(this.context), null);
            cr.channelCreated(StatusFactory.getStatusCreate().getStatusOK(), serverChannel);
        } else {
            List<ChannelProvider> providers = this.context.getChannelProviders();
            if (providers.size() == 1) {
                providers.get(0).createChannel(channelName, cr, transport.getPriority());
            } else {
                ChannelProvider provider = this.context.getChannelNameToProviderMap().get(channelName);
                if (provider != null) {
                    provider.createChannel(channelName, cr, transport.getPriority());
                } else {
                    Status asStatus = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "Multiple providers installed, but there is no channel to provider mapping available (not implemented).", null);
                    cr.channelCreated(asStatus, null);
                    return;
                }
            }
        }
    }

    private void disconnect(Transport transport) {
        try {
            transport.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class ChannelRequesterImpl
    implements ChannelRequester,
    TransportSender {
        private final Transport transport;
        private final String channelName;
        private final int cid;
        private final SecurityPlugin.ChannelSecuritySession css;
        private Status status;
        private Channel channel;

        public ChannelRequesterImpl(Transport transport, String channelName, int cid, SecurityPlugin.ChannelSecuritySession css) {
            this.transport = transport;
            this.channelName = channelName;
            this.cid = cid;
            this.css = css;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelCreated(Status status, Channel channel) {
            ChannelRequesterImpl channelRequesterImpl = this;
            synchronized (channelRequesterImpl) {
                this.status = status;
                this.channel = channel;
            }
            this.transport.enqueueSendRequest(this);
        }

        @Override
        public void channelStateChange(Channel c, Channel.ConnectionState isConnected) {
        }

        public String getRequesterName() {
            return this.transport + "/" + this.cid;
        }

        public void message(String message, MessageType messageType) {
            System.err.println("[" + messageType + "] " + message);
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            block11: {
                Status status;
                Channel channel;
                ChannelRequesterImpl channelRequesterImpl = this;
                synchronized (channelRequesterImpl) {
                    channel = this.channel;
                    status = this.status;
                }
                if (channel == null) {
                    this.createChannelFailedResponse(buffer, control, status);
                    if (this.css != null) {
                        this.css.close();
                    }
                } else {
                    ServerChannelImpl serverChannel = null;
                    try {
                        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)this.transport);
                        int sid = casTransport.preallocateChannelSID();
                        try {
                            serverChannel = new ServerChannelImpl(channel, this.cid, sid, this.css);
                            casTransport.registerChannel(sid, serverChannel);
                        }
                        catch (Throwable th) {
                            casTransport.depreallocateChannelSID(sid);
                            throw th;
                        }
                        control.startMessage((byte)7, 8);
                        buffer.putInt(this.cid);
                        buffer.putInt(sid);
                        status.serialize(buffer, (SerializableControl)control);
                    }
                    catch (Throwable th) {
                        CreateChannelHandler.this.context.getLogger().log(Level.WARNING, "Exception caught when creating channel: " + this.channelName, th);
                        this.createChannelFailedResponse(buffer, control, BaseChannelRequester.statusCreate.createStatus(Status.StatusType.FATAL, "failed to create channel", th));
                        if (serverChannel != null) {
                            serverChannel.destroy();
                        }
                        if (this.css == null) break block11;
                        this.css.close();
                    }
                }
            }
        }

        private void createChannelFailedResponse(ByteBuffer buffer, TransportSendControl control, Status status) {
            control.startMessage((byte)7, 8);
            buffer.putInt(this.cid);
            buffer.putInt(-1);
            status.serialize(buffer, (SerializableControl)control);
        }
    }
}

