/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.nio.ByteBuffer;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvdata.misc.Destroyable;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.Requester;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

abstract class BaseChannelRequester
implements Requester,
Destroyable {
    public static final StatusCreate statusCreate = PVFactory.getStatusCreate();
    public static final Status okStatus = statusCreate.getStatusOK();
    public static final Status badCIDStatus = statusCreate.createStatus(Status.StatusType.ERROR, "bad channel id", null);
    public static final Status badIOIDStatus = statusCreate.createStatus(Status.StatusType.ERROR, "bad request id", null);
    public static final Status noReadACLStatus = statusCreate.createStatus(Status.StatusType.ERROR, "no read access", null);
    public static final Status noWriteACLStatus = statusCreate.createStatus(Status.StatusType.ERROR, "no write access", null);
    public static final Status noProcessACLStatus = statusCreate.createStatus(Status.StatusType.ERROR, "no process access", null);
    public static final Status otherRequestPendingStatus = statusCreate.createStatus(Status.StatusType.ERROR, "other request pending", null);
    public static final Status notAChannelRequest = statusCreate.createStatus(Status.StatusType.ERROR, "not a channel request", null);
    protected final ServerContextImpl context;
    protected final ServerChannelImpl channel;
    protected final int ioid;
    protected final Transport transport;
    private static final int NULL_REQUEST = -1;
    protected int pendingRequest = -1;

    public BaseChannelRequester(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport) {
        this.context = context;
        this.channel = channel;
        this.ioid = ioid;
        this.transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRequest(int qos) {
        BaseChannelRequester baseChannelRequester = this;
        synchronized (baseChannelRequester) {
            if (this.pendingRequest != -1) {
                return false;
            }
            this.pendingRequest = qos;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRequest() {
        BaseChannelRequester baseChannelRequester = this;
        synchronized (baseChannelRequester) {
            this.pendingRequest = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingRequest() {
        BaseChannelRequester baseChannelRequester = this;
        synchronized (baseChannelRequester) {
            return this.pendingRequest;
        }
    }

    public String getRequesterName() {
        return this.transport + "/" + this.ioid;
    }

    public void message(String message, MessageType messageType) {
        BaseChannelRequester.message(this.transport, this.ioid, message, messageType);
    }

    public static void message(Transport transport, final int ioid, final String message, final MessageType messageType) {
        transport.enqueueSendRequest(new TransportSender(){

            @Override
            public void send(ByteBuffer buffer, TransportSendControl control) {
                control.startMessage((byte)18, 5);
                buffer.putInt(ioid);
                buffer.put((byte)messageType.ordinal());
                SerializeHelper.serializeString((String)message, (ByteBuffer)buffer, (SerializableControl)control);
            }

            @Override
            public void lock() {
            }

            @Override
            public void unlock() {
            }
        });
    }

    public static void sendFailureMessage(final byte command, Transport transport, final int ioid, final byte qos, final Status status) {
        transport.enqueueSendRequest(new TransportSender(){

            @Override
            public void send(ByteBuffer buffer, TransportSendControl control) {
                control.startMessage(command, 5);
                buffer.putInt(ioid);
                buffer.put(qos);
                status.serialize(buffer, (SerializableControl)control);
            }

            @Override
            public void lock() {
            }

            @Override
            public void unlock() {
            }
        });
    }
}

