/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.impl.security.AuthNZHandler;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.ArrayHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BadResponse;
import org.epics.pvaccess.server.impl.remote.handlers.CancelRequestHandler;
import org.epics.pvaccess.server.impl.remote.handlers.ConnectionValidationHandler;
import org.epics.pvaccess.server.impl.remote.handlers.CreateChannelHandler;
import org.epics.pvaccess.server.impl.remote.handlers.DestroyChannelHandler;
import org.epics.pvaccess.server.impl.remote.handlers.DestroyRequestHandler;
import org.epics.pvaccess.server.impl.remote.handlers.EchoHandler;
import org.epics.pvaccess.server.impl.remote.handlers.GetFieldHandler;
import org.epics.pvaccess.server.impl.remote.handlers.GetHandler;
import org.epics.pvaccess.server.impl.remote.handlers.MonitorHandler;
import org.epics.pvaccess.server.impl.remote.handlers.NoopResponse;
import org.epics.pvaccess.server.impl.remote.handlers.ProcessHandler;
import org.epics.pvaccess.server.impl.remote.handlers.PutGetHandler;
import org.epics.pvaccess.server.impl.remote.handlers.PutHandler;
import org.epics.pvaccess.server.impl.remote.handlers.RPCHandler;
import org.epics.pvaccess.server.impl.remote.handlers.SearchHandler;
import org.epics.pvaccess.util.HexDump;

public final class ServerResponseHandler
implements ResponseHandler {
    private final ResponseHandler[] handlerTable;
    private final ServerContextImpl context;

    public ServerResponseHandler(ServerContextImpl context) {
        this.context = context;
        BadResponse badResponse = new BadResponse(context);
        this.handlerTable = new ResponseHandler[]{new NoopResponse(context, "Beacon"), new ConnectionValidationHandler(context), new EchoHandler(context), new SearchHandler(context), badResponse, new AuthNZHandler(context.getDebugLevel() >= 3), badResponse, new CreateChannelHandler(context), new DestroyChannelHandler(context), badResponse, new GetHandler(context), new PutHandler(context), new PutGetHandler(context), new MonitorHandler(context), new ArrayHandler(context), new DestroyRequestHandler(context), new ProcessHandler(context), new GetFieldHandler(context), badResponse, badResponse, new RPCHandler(context), new CancelRequestHandler(context), new NoopResponse(context, "Origin tag"), badResponse, badResponse, badResponse, badResponse, badResponse};
    }

    @Override
    public final void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        if (command < 0 || command >= this.handlerTable.length) {
            this.context.getLogger().fine("Invalid (or unsupported) command: " + command + ".");
            HexDump.hexDump("Invalid PVA header " + command + " + , its payload buffer", payloadBuffer.array(), payloadBuffer.position(), payloadSize);
            return;
        }
        this.handlerTable[command].handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
    }
}

