/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvaccess.PVAException;
import org.epics.pvaccess.Version;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelProviderRegistry;
import org.epics.pvaccess.client.ChannelProviderRegistryFactory;
import org.epics.pvaccess.impl.remote.ConnectionException;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.ProtocolType;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportRegistry;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.impl.remote.udp.BlockingUDPConnector;
import org.epics.pvaccess.impl.remote.udp.BlockingUDPTransport;
import org.epics.pvaccess.plugins.SecurityPlugin;
import org.epics.pvaccess.server.ServerContext;
import org.epics.pvaccess.server.impl.remote.BeaconEmitter;
import org.epics.pvaccess.server.impl.remote.ServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.tcp.BlockingTCPAcceptor;
import org.epics.pvaccess.server.plugins.BeaconServerStatusProvider;
import org.epics.pvaccess.util.InetAddressUtil;
import org.epics.pvaccess.util.configuration.Configuration;
import org.epics.pvaccess.util.configuration.ConfigurationProvider;
import org.epics.pvaccess.util.configuration.impl.ConfigurationFactory;
import org.epics.pvaccess.util.logging.ConsoleLogHandler;
import org.epics.pvdata.misc.ThreadPriority;
import org.epics.pvdata.misc.Timer;
import org.epics.pvdata.misc.TimerFactory;

public class ServerContextImpl
implements ServerContext,
Context {
    public static final Version VERSION;
    private volatile State state = State.NOT_INITIALIZED;
    protected Logger logger;
    protected int debugLevel;
    protected String beaconAddressList = "";
    protected String ignoreAddressList = "";
    protected boolean autoBeaconAddressList = true;
    protected float beaconPeriod = 15.0f;
    protected int broadcastPort = 5076;
    protected int serverPort = 5075;
    protected int receiveBufferSize = 16384;
    protected Timer timer = null;
    protected BlockingUDPTransport broadcastTransport = null;
    protected BlockingUDPTransport localMulticastTransport = null;
    protected BeaconEmitter beaconEmitter = null;
    protected BlockingTCPAcceptor acceptor = null;
    protected TransportRegistry transportRegistry = null;
    protected String channelProviderNames = "local";
    protected final ArrayList<ChannelProvider> channelProviders = new ArrayList();
    protected final Map<String, ChannelProvider> channelNameToProvider = new HashMap<String, ChannelProvider>();
    private final ResponseHandler serverResponseHandler;
    protected final Object runLock = new Object();
    private final byte[] guid = new byte[12];
    private boolean runTerminated;
    private BeaconServerStatusProvider beaconServerStatusProvider = null;
    private final Map<String, SecurityPlugin> securityPlugins = new LinkedHashMap<String, SecurityPlugin>();

    public ServerContextImpl() {
        this.generateGUID();
        this.loadConfiguration();
        this.initializeLogger();
        this.initializeSecutiryPlugins();
        this.serverResponseHandler = new ServerResponseHandler(this);
    }

    private void generateGUID() {
        UUID uuid4 = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(this.guid);
        bb.putLong(uuid4.getMostSignificantBits());
        bb.putInt((int)(uuid4.getLeastSignificantBits() >>> 32));
    }

    public byte[] getGUID() {
        return this.guid;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    protected void initializeLogger() {
        this.logger = Logger.getLogger(this.getClass().getName());
        if (this.debugLevel > 0) {
            this.logger.setLevel(Level.ALL);
            boolean found = false;
            block0: for (Logger inspectedLogger = this.logger; inspectedLogger != null; inspectedLogger = inspectedLogger.getParent()) {
                for (Handler handler : inspectedLogger.getHandlers()) {
                    if (!(handler instanceof ConsoleLogHandler)) continue;
                    found = true;
                    continue block0;
                }
            }
            if (!found) {
                this.logger.addHandler(new ConsoleLogHandler());
            }
        }
    }

    public Configuration getConfiguration() {
        ConfigurationProvider configurationProvider = ConfigurationFactory.getProvider();
        Configuration config = configurationProvider.getConfiguration("pvAccess-server");
        if (config == null) {
            config = configurationProvider.getConfiguration("system");
        }
        return config;
    }

    protected void loadConfiguration() {
        Configuration config = this.getConfiguration();
        this.debugLevel = config.getPropertyAsInteger("EPICS_PVA_DEBUG", 0);
        this.beaconAddressList = config.getPropertyAsString("EPICS_PVA_ADDR_LIST", this.beaconAddressList);
        this.beaconAddressList = config.getPropertyAsString("EPICS_PVAS_BEACON_ADDR_LIST", this.beaconAddressList);
        this.autoBeaconAddressList = config.getPropertyAsBoolean("EPICS_PVA_AUTO_ADDR_LIST", this.autoBeaconAddressList);
        this.autoBeaconAddressList = config.getPropertyAsBoolean("EPICS_PVAS_AUTO_BEACON_ADDR_LIST", this.autoBeaconAddressList);
        this.beaconPeriod = config.getPropertyAsFloat("EPICS_PVA_BEACON_PERIOD", this.beaconPeriod);
        this.beaconPeriod = config.getPropertyAsFloat("EPICS_PVAS_BEACON_PERIOD", this.beaconPeriod);
        this.serverPort = config.getPropertyAsInteger("EPICS_PVA_SERVER_PORT", this.serverPort);
        this.serverPort = config.getPropertyAsInteger("EPICS_PVAS_SERVER_PORT", this.serverPort);
        this.broadcastPort = config.getPropertyAsInteger("EPICS_PVA_BROADCAST_PORT", this.broadcastPort);
        this.broadcastPort = config.getPropertyAsInteger("EPICS_PVAS_BROADCAST_PORT", this.broadcastPort);
        this.receiveBufferSize = config.getPropertyAsInteger("EPICS_PVA_MAX_ARRAY_BYTES", this.receiveBufferSize);
        this.receiveBufferSize = config.getPropertyAsInteger("EPICS_PVAS_MAX_ARRAY_BYTES", this.receiveBufferSize);
        this.channelProviderNames = config.getPropertyAsString("EPICS_PVA_PROVIDER_NAMES", this.channelProviderNames);
        this.channelProviderNames = config.getPropertyAsString("EPICS_PVAS_PROVIDER_NAMES", this.channelProviderNames);
    }

    public void setChannelProviderNames(String providerNames) {
        this.channelProviderNames = providerNames;
    }

    protected final void checkState() throws PVAException, IllegalStateException {
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context destroyed.");
        }
    }

    @Override
    public synchronized void initialize(ChannelProviderRegistry providerRegistry) throws PVAException, IllegalStateException {
        if (providerRegistry == null) {
            throw new IllegalArgumentException("non-null providerRegistry expected");
        }
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state != State.NOT_INITIALIZED) {
            throw new IllegalStateException("Context already initialized.");
        }
        if (this.channelProviderNames.equals("<all>")) {
            StringBuffer names = new StringBuffer(64);
            for (String name : providerRegistry.getProviderNames()) {
                this.channelProviders.add(providerRegistry.getProvider(name));
                if (names.length() > 0) {
                    names.append(' ');
                }
                names.append(name);
            }
            this.channelProviderNames = names.toString();
        } else {
            String[] names;
            for (String name : names = this.channelProviderNames.split("\\s+")) {
                ChannelProvider channelProvider = providerRegistry.getProvider(name);
                if (channelProvider == null) {
                    this.logger.warning("Channel provider with name '" + name + "' not available.");
                    continue;
                }
                this.channelProviders.add(channelProvider);
            }
        }
        if (this.channelProviders.isEmpty()) {
            throw new RuntimeException("None of the specified channel providers are available: " + this.channelProviderNames + ".");
        }
        this.internalInitialize();
        this.state = State.INITIALIZED;
    }

    @Override
    public synchronized void initialize(ChannelProvider channelProvider) throws PVAException, IllegalStateException {
        if (channelProvider == null) {
            throw new IllegalArgumentException("non-null channelProvider expected");
        }
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state != State.NOT_INITIALIZED) {
            throw new IllegalStateException("Context already initialized.");
        }
        this.channelProviders.add(channelProvider);
        this.channelProviderNames = channelProvider.getProviderName();
        this.internalInitialize();
        this.state = State.INITIALIZED;
    }

    private void internalInitialize() throws PVAException {
        this.timer = TimerFactory.create((String)"pvAccess-server timer", (ThreadPriority)ThreadPriority.lower);
        this.transportRegistry = new TransportRegistry();
        this.acceptor = new BlockingTCPAcceptor(this, this.serverPort, this.receiveBufferSize);
        this.serverPort = this.acceptor.getBindAddress().getPort();
        this.initializeUDPTransport();
        this.beaconEmitter = new BeaconEmitter(ProtocolType.tcp.name(), this.broadcastTransport, this);
    }

    private void initializeUDPTransport() throws PVAException {
        try {
            NetworkInterface localNIF;
            InetSocketAddress[] list;
            InetSocketAddress listenLocalAddress = new InetSocketAddress(this.broadcastPort);
            InetSocketAddress[] broadcastAddresses = InetAddressUtil.getBroadcastAddresses(this.broadcastPort);
            BlockingUDPConnector broadcastConnector = new BlockingUDPConnector(this, true, broadcastAddresses, true);
            this.broadcastTransport = (BlockingUDPTransport)broadcastConnector.connect(null, this.serverResponseHandler, listenLocalAddress, (byte)1, (short)0);
            if (this.ignoreAddressList != null && this.ignoreAddressList.length() > 0 && (list = InetAddressUtil.getSocketAddressList(this.ignoreAddressList, 0)) != null && list.length > 0) {
                this.broadcastTransport.setIgnoredAddresses(list);
            }
            if (this.beaconAddressList != null && this.beaconAddressList.length() > 0) {
                InetSocketAddress[] list2;
                InetSocketAddress[] appendList = null;
                if (this.autoBeaconAddressList) {
                    appendList = this.broadcastTransport.getSendAddresses();
                }
                if ((list2 = InetAddressUtil.getSocketAddressList(this.beaconAddressList, this.broadcastPort, appendList)) != null && list2.length > 0) {
                    this.broadcastTransport.setSendAddresses(list2);
                }
            }
            if ((localNIF = InetAddressUtil.getLoopbackNIF()) != null) {
                try {
                    InetAddress group = InetAddress.getByName("224.0.0.128");
                    this.broadcastTransport.join(group, localNIF);
                    InetSocketAddress anyAddress = new InetSocketAddress(0);
                    this.localMulticastTransport = (BlockingUDPTransport)broadcastConnector.connect(null, this.serverResponseHandler, anyAddress, (byte)1, (short)0);
                    this.localMulticastTransport.setMutlicastNIF(localNIF, true);
                    this.localMulticastTransport.setSendAddresses(new InetSocketAddress[]{new InetSocketAddress(group, this.broadcastPort)});
                    this.logger.config("Local multicast enabled on " + group + ":" + this.broadcastPort + " using " + localNIF.getDisplayName() + ".");
                }
                catch (Throwable th) {
                    if (this.localMulticastTransport != null) {
                        try {
                            this.localMulticastTransport.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.localMulticastTransport = null;
                    }
                    this.logger.log(Level.CONFIG, "Failed to initialize local multicast, funcionality disabled.", th);
                }
            } else {
                this.logger.config("Failed to detect a loopback network interface, local multicast disabled.");
            }
            this.broadcastTransport.start();
        }
        catch (ConnectionException ce) {
            throw new PVAException("Failed to initialize broadcast UDP transport", ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(int seconds) throws PVAException, IllegalStateException {
        if (seconds < 0) {
            throw new IllegalArgumentException("seconds cannot be negative.");
        }
        if (this.state == State.NOT_INITIALIZED) {
            throw new IllegalStateException("Context not initialized.");
        }
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state == State.RUNNING) {
            throw new IllegalStateException("Context is already running.");
        }
        if (this.state == State.SHUTDOWN) {
            throw new IllegalStateException("Context was shutdown.");
        }
        Object object = this;
        synchronized (object) {
            if (this.state == State.SHUTDOWN) {
                throw new IllegalStateException("Context was shutdown.");
            }
            this.state = State.RUNNING;
        }
        this.beaconEmitter.start();
        object = this.runLock;
        synchronized (object) {
            this.runTerminated = false;
            try {
                long timeToWait = seconds * 1000;
                long start = System.currentTimeMillis();
                while (!(this.runTerminated || timeToWait != 0L && System.currentTimeMillis() - start >= timeToWait)) {
                    this.runLock.wait(timeToWait);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = this;
        synchronized (object) {
            this.state = State.SHUTDOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() throws PVAException, IllegalStateException {
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context already destroyed.");
        }
        Object object = this.runLock;
        synchronized (object) {
            this.runTerminated = true;
            this.runLock.notifyAll();
        }
    }

    @Override
    public synchronized void destroy() throws PVAException, IllegalStateException {
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context already destroyed.");
        }
        this.shutdown();
        this.state = State.DESTROYED;
        this.internalDestroy();
    }

    private void internalDestroy() throws PVAException {
        if (this.broadcastTransport != null) {
            try {
                this.broadcastTransport.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.localMulticastTransport != null) {
            try {
                this.localMulticastTransport.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.acceptor != null) {
            this.acceptor.destroy();
        }
        if (this.beaconEmitter != null) {
            this.beaconEmitter.destroy();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.destroyAllTransports();
    }

    private void destroyAllTransports() {
        if (this.transportRegistry == null) {
            return;
        }
        Transport[] transports = this.transportRegistry.toArray();
        if (transports.length == 0) {
            return;
        }
        this.logger.fine("Server context still has " + transports.length + " transport(s) active and closing...");
        for (int i = 0; i < transports.length; ++i) {
            Transport transport = transports[i];
            try {
                transport.close();
                continue;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    @Override
    public void printInfo() {
        this.printInfo(System.out);
    }

    @Override
    public void printInfo(PrintStream out) {
        out.println("CLASS   : " + this.getClass().getName());
        out.println("VERSION : " + this.getVersion());
        out.println("PROVIDER_NAMES : " + this.channelProviderNames);
        out.println("BEACON_ADDR_LIST : " + this.beaconAddressList);
        out.println("AUTO_BEACON_ADDR_LIST : " + this.autoBeaconAddressList);
        out.println("BEACON_PERIOD : " + this.beaconPeriod);
        out.println("BROADCAST_PORT : " + this.broadcastPort);
        out.println("SERVER_PORT : " + this.serverPort);
        out.println("RCV_BUFFER_SIZE : " + this.receiveBufferSize);
        out.println("IGNORE_ADDR_LIST: " + this.ignoreAddressList);
        out.println("STATE : " + this.state.name());
    }

    @Override
    public void dispose() {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isInitialized() {
        return this.state == State.INITIALIZED || this.state == State.RUNNING || this.state == State.SHUTDOWN;
    }

    public boolean isDestroyed() {
        return this.state == State.DESTROYED;
    }

    public String getBeaconAddressList() {
        return this.beaconAddressList;
    }

    public boolean isAutoBeaconAddressList() {
        return this.autoBeaconAddressList;
    }

    public float getBeaconPeriod() {
        return this.beaconPeriod;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public int getBroadcastPort() {
        return this.broadcastPort;
    }

    public String getIgnoreAddressList() {
        return this.ignoreAddressList;
    }

    public BeaconServerStatusProvider getBeaconServerStatusProvider() {
        return this.beaconServerStatusProvider;
    }

    @Override
    public void setBeaconServerStatusProvider(BeaconServerStatusProvider beaconServerStatusProvider) {
        this.beaconServerStatusProvider = beaconServerStatusProvider;
    }

    public InetAddress getServerInetAddress() {
        return this.acceptor != null ? this.acceptor.getBindAddress().getAddress() : null;
    }

    public BlockingUDPTransport getBroadcastTransport() {
        return this.broadcastTransport;
    }

    public BlockingUDPTransport getLocalMulticastTransport() {
        return this.localMulticastTransport;
    }

    @Override
    public TransportRegistry getTransportRegistry() {
        return this.transportRegistry;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public Map<String, SecurityPlugin> getSecurityPlugins() {
        return this.securityPlugins;
    }

    private void initializeSecutiryPlugins() {
        String classes = System.getProperty(SecurityPlugin.SECURITY_PLUGINS_SERVER_KEY);
        if (classes != null) {
            StringTokenizer tokens = new StringTokenizer(classes, ",");
            while (tokens.hasMoreElements()) {
                String className = tokens.nextToken().trim();
                this.logger.log(Level.FINER, "Loading security plug-in '" + className + "'...");
                try {
                    Class<?> c = Class.forName(className);
                    SecurityPlugin p = (SecurityPlugin)c.newInstance();
                    this.securityPlugins.put(p.getId(), p);
                    this.logger.log(Level.FINER, "Security plug-in '" + className + "' [" + p.getId() + "] loaded.");
                }
                catch (Throwable th) {
                    this.logger.log(Level.WARNING, "Failed to load security plug-in '" + className + "'.", th);
                }
            }
        }
        this.logger.log(Level.FINE, "Installed security plug-ins: " + this.securityPlugins.keySet() + ".");
    }

    public String getChannelProviderNames() {
        return this.channelProviderNames;
    }

    public List<ChannelProvider> getChannelProviders() {
        return this.channelProviders;
    }

    public Map<String, ChannelProvider> getChannelNameToProviderMap() {
        return this.channelNameToProvider;
    }

    public ResponseHandler getServerResponseHandler() {
        return this.serverResponseHandler;
    }

    public static ServerContextImpl startPVAServer(String providerNames, final int timeToRun, boolean runInSeparateThread, PrintStream printInfoStream) throws PVAException {
        final ServerContextImpl context = new ServerContextImpl();
        if (providerNames != null) {
            context.setChannelProviderNames(providerNames);
        }
        context.initialize(ChannelProviderRegistryFactory.getChannelProviderRegistry());
        if (printInfoStream != null) {
            printInfoStream.println(context.getVersion().getVersionString());
            context.printInfo(printInfoStream);
        }
        if (runInSeparateThread) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        context.run(timeToRun);
                    }
                    catch (Throwable th) {
                        Logger logger = Logger.getLogger(this.getClass().getName());
                        logger.log(Level.SEVERE, "Unhandled exception caught.", th);
                    }
                }
            }, "startPVAServer").start();
        } else {
            context.run(timeToRun);
        }
        return context;
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        VERSION = new Version("pvAccess Server", "Java", 5, 1, 0, true);
    }

    static enum State {
        NOT_INITIALIZED,
        INITIALIZED,
        RUNNING,
        SHUTDOWN,
        DESTROYED;

    }
}

