/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.utils;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.epics.pvaccess.impl.remote.utils.GUID;
import org.epics.pvaccess.util.InetAddressUtil;
import org.epics.pvaccess.util.configuration.Configuration;
import org.epics.pvaccess.util.configuration.ConfigurationProvider;
import org.epics.pvaccess.util.configuration.impl.ConfigurationFactory;
import org.epics.pvdata.misc.SerializeHelper;

public class ServerList {
    private static final Map<GUID, ServerEntry> serverMap;

    private static boolean send(DatagramChannel channel, InetSocketAddress[] sendAddresses, ByteBuffer buffer) {
        if (sendAddresses == null) {
            return false;
        }
        for (int i = 0; i < sendAddresses.length; ++i) {
            try {
                buffer.flip();
                channel.send(buffer, sendAddresses[i]);
                continue;
            }
            catch (NoRouteToHostException nrthe) {
                System.err.println("No route to host exception caught when sending to: " + sendAddresses[i] + ".");
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static final void processSearchResponse(InetSocketAddress responseFrom, ByteBuffer socketBuffer) throws IOException {
        InetAddress addr;
        byte magicCode = socketBuffer.get();
        byte version = socketBuffer.get();
        byte flags = socketBuffer.get();
        if ((flags & 0x80) == 128) {
            socketBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            socketBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        byte command = socketBuffer.get();
        if (command != 4) {
            return;
        }
        int payloadSize = socketBuffer.getInt();
        if (payloadSize < 34) {
            return;
        }
        if (magicCode != -54) {
            return;
        }
        byte[] guid = new byte[12];
        socketBuffer.get(guid);
        socketBuffer.getInt();
        byte[] byteAddress = new byte[16];
        socketBuffer.get(byteAddress);
        int port = socketBuffer.getShort() & 0xFFFF;
        try {
            addr = InetAddress.getByAddress(byteAddress);
        }
        catch (UnknownHostException e) {
            return;
        }
        responseFrom = !addr.isAnyLocalAddress() ? new InetSocketAddress(addr, port) : new InetSocketAddress(responseFrom.getAddress(), port);
        String protocol = SerializeHelper.deserializeString((ByteBuffer)socketBuffer);
        socketBuffer.get();
        GUID g = new GUID(guid);
        ServerEntry se = serverMap.get(g);
        if (se != null) {
            se.addAddress(responseFrom);
        } else {
            serverMap.put(g, new ServerEntry(g, protocol, responseFrom, version));
        }
    }

    public static void main(String[] args) throws Throwable {
        ConfigurationProvider configurationProvider = ConfigurationFactory.getProvider();
        Configuration config = configurationProvider.getConfiguration("pvAccess-client");
        if (config == null) {
            config = configurationProvider.getConfiguration("system");
        }
        String addressList = config.getPropertyAsString("EPICS_PVA_ADDR_LIST", "");
        boolean autoAddressList = config.getPropertyAsBoolean("EPICS_PVA_AUTO_ADDR_LIST", true);
        int broadcastPort = config.getPropertyAsInteger("EPICS_PVA_BROADCAST_PORT", 5076);
        InetSocketAddress[] broadcastAddresses = InetAddressUtil.getBroadcastAddresses(broadcastPort);
        if (addressList != null && addressList.length() > 0) {
            InetSocketAddress[] appendList = null;
            if (autoAddressList) {
                appendList = broadcastAddresses;
            }
            broadcastAddresses = InetAddressUtil.getSocketAddressList(addressList, broadcastPort, appendList);
        }
        System.out.println("Searching...");
        DatagramChannel datagramChannel = DatagramChannel.open();
        datagramChannel.configureBlocking(true);
        datagramChannel.socket().setBroadcast(true);
        datagramChannel.socket().setSoTimeout(1000);
        datagramChannel.bind(new InetSocketAddress(0));
        ByteBuffer sendBuffer = ByteBuffer.allocate(1024);
        sendBuffer.put((byte)-54);
        sendBuffer.put((byte)1);
        sendBuffer.put((byte)-128);
        sendBuffer.put((byte)3);
        sendBuffer.putInt(29);
        sendBuffer.putInt(0);
        sendBuffer.put((byte)-127);
        sendBuffer.put((byte)0);
        sendBuffer.putShort((short)0);
        InetSocketAddress address = (InetSocketAddress)datagramChannel.getLocalAddress();
        InetAddressUtil.encodeAsIPv6Address(sendBuffer, address.getAddress());
        sendBuffer.putShort((short)address.getPort());
        sendBuffer.put((byte)0);
        sendBuffer.putShort((short)0);
        ServerList.send(datagramChannel, broadcastAddresses, sendBuffer);
        ByteBuffer receiveBuffer = ByteBuffer.allocate(1024);
        DatagramPacket dp = new DatagramPacket(receiveBuffer.array(), receiveBuffer.capacity());
        while (true) {
            SocketAddress responseFrom;
            try {
                datagramChannel.socket().receive(dp);
                responseFrom = dp.getSocketAddress();
                receiveBuffer.position(dp.getLength());
            }
            catch (SocketTimeoutException ste) {
                break;
            }
            receiveBuffer.flip();
            ServerList.processSearchResponse((InetSocketAddress)responseFrom, receiveBuffer);
        }
        for (ServerEntry se : serverMap.values()) {
            System.out.println(se);
        }
        System.out.println("done.");
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        serverMap = new HashMap<GUID, ServerEntry>();
    }

    private static class ServerEntry {
        GUID guid;
        String protocol;
        final Set<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        byte version;

        public ServerEntry(GUID guid, String protocol, InetSocketAddress address, byte version) {
            this.guid = guid;
            this.protocol = protocol;
            this.addresses.add(address);
            this.version = version;
        }

        public void addAddress(InetSocketAddress address) {
            this.addresses.add(address);
        }

        public String toString() {
            StringBuffer b = new StringBuffer(200);
            b.append("GUID ").append(this.guid).append(", version ").append(this.version).append(": ");
            b.append(this.protocol).append('@');
            b.append(Arrays.toString(this.addresses.toArray()));
            return b.toString();
        }
    }
}

