/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.udp;

import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import org.epics.pvaccess.impl.remote.ConnectionException;
import org.epics.pvaccess.impl.remote.Connector;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.ProtocolType;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportClient;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.impl.remote.udp.BlockingUDPTransport;

public class BlockingUDPConnector
implements Connector {
    private Context context;
    private InetSocketAddress[] sendAddresses;
    private boolean reuseSocket;
    private boolean broadcast;

    public BlockingUDPConnector(Context context, boolean reuseSocket, InetSocketAddress[] sendAddresses, boolean broadcast) {
        this.context = context;
        this.reuseSocket = reuseSocket;
        this.sendAddresses = sendAddresses;
        this.broadcast = broadcast;
    }

    @Override
    public Transport connect(TransportClient client, ResponseHandler responseHandler, InetSocketAddress bindAddress, byte transportRevision, short priority) throws ConnectionException {
        this.context.getLogger().finer("Creating datagram socket to " + bindAddress + ".");
        DatagramChannel socket = null;
        try {
            socket = DatagramChannel.open(StandardProtocolFamily.INET);
            socket.configureBlocking(true);
            if (this.broadcast) {
                socket.socket().setBroadcast(true);
            }
            if (this.reuseSocket) {
                socket.socket().setReuseAddress(true);
            }
            socket.socket().bind(bindAddress);
            return new BlockingUDPTransport(this.context, responseHandler, socket, bindAddress, this.sendAddresses, transportRevision);
        }
        catch (Throwable th) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ConnectionException("Failed to bind to '" + bindAddress + "'.", bindAddress, ProtocolType.udp.name(), th);
        }
    }
}

