/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.IntrospectionRegistry;
import org.epics.pvaccess.impl.remote.ProtocolType;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.codec.impl.NonBlockingSocketAbstractCodec;
import org.epics.pvaccess.impl.remote.io.Poller;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.server.ServerContext;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.Status;

public abstract class NonBlockingTCPTransport
extends NonBlockingSocketAbstractCodec
implements Transport {
    protected final Context context;
    protected final short priority;
    protected final ResponseHandler responseHandler;
    protected final IntrospectionRegistry incomingIR = new IntrospectionRegistry();
    protected final IntrospectionRegistry outgoingIR = new IntrospectionRegistry();
    protected byte remoteTransportRevision;
    protected boolean verified = false;
    private Object verifiedMonitor = new Object();

    public NonBlockingTCPTransport(Context context, Poller poller, SocketChannel channel, ResponseHandler responseHandler, int receiveBufferSize, short priority) throws SocketException {
        super(context instanceof ServerContext, poller, channel, ByteBuffer.allocate(Math.max(16896, receiveBufferSize)), ByteBuffer.allocate(Math.max(16896, receiveBufferSize)), context.getLogger());
        this.context = context;
        this.responseHandler = responseHandler;
        this.remoteTransportRevision = 0;
        this.priority = priority;
        context.getTransportRegistry().put(this);
    }

    @Override
    protected void internalDestroy() {
        super.internalDestroy();
        this.context.getTransportRegistry().remove(this);
        this.internalClose();
    }

    protected void internalClose() {
    }

    @Override
    public String getType() {
        return ProtocolType.tcp.name();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.socketAddress;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public byte getRevision() {
        return 1;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.socketBuffer.capacity();
    }

    @Override
    public int getSocketReceiveBufferSize() {
        try {
            return this.channel.socket().getReceiveBufferSize();
        }
        catch (SocketException e) {
            return -1;
        }
    }

    @Override
    public short getPriority() {
        return this.priority;
    }

    @Override
    public void setRemoteRevision(byte minor) {
    }

    @Override
    public void setRemoteTransportReceiveBufferSize(int receiveBufferSize) {
    }

    @Override
    public void setRemoteTransportSocketReceiveBufferSize(int socketReceiveBufferSize) {
    }

    @Override
    public void changedTransport() {
    }

    @Override
    public void processControlMessage() {
        if (this.command == 2) {
            this.setByteOrder(this.flags < 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public void processApplicationMessage() throws IOException {
        this.responseHandler.handleResponse(this.socketAddress, this, this.version, this.command, this.payloadSize, this.socketBuffer);
    }

    public Field cachedDeserialize(ByteBuffer buffer) {
        return this.incomingIR.deserialize(buffer, this);
    }

    public void cachedSerialize(Field field, ByteBuffer buffer) {
        this.outgoingIR.serialize(field, buffer, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verified(Status status) {
        Object object = this.verifiedMonitor;
        synchronized (object) {
            if (!status.isOK()) {
                String logMessage = "Failed to verify connection to " + this.socketAddress + ": " + status.getMessage();
                String stackDump = status.getStackDump();
                if (stackDump != null && !stackDump.isEmpty()) {
                    logMessage = logMessage + "\n" + stackDump;
                }
                this.context.getLogger().fine(logMessage);
            }
            this.verified = status.isSuccess();
            this.verifiedMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(long timeoutMs) {
        Object object = this.verifiedMonitor;
        synchronized (object) {
            try {
                long start = System.currentTimeMillis();
                while (!this.verified && System.currentTimeMillis() - start < timeoutMs) {
                    this.verifiedMonitor.wait(timeoutMs);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.verified;
        }
    }
}

