/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.request;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.util.HexDump;

public abstract class AbstractResponseHandler
implements ResponseHandler {
    protected final String description;
    protected final boolean debug;

    public AbstractResponseHandler(String description, boolean debug) {
        this.description = description;
        this.debug = debug;
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        if (this.debug) {
            if (payloadBuffer.hasArray()) {
                HexDump.hexDump("Message [" + command + ", v" + Integer.toHexString(version) + "] received from " + responseFrom, this.description, payloadBuffer.array(), payloadBuffer.position(), Math.min(payloadSize, payloadBuffer.limit() - payloadBuffer.position()));
            } else {
                System.out.println("Message [" + command + ", v" + Integer.toHexString(version) + "] received from " + responseFrom + ", payload size = " + payloadSize);
            }
        }
    }
}

