/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.codec.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import org.epics.pvaccess.impl.remote.codec.impl.NonBlockingAbstractCodec;
import org.epics.pvaccess.impl.remote.io.Poller;

public abstract class NonBlockingSocketAbstractCodec
extends NonBlockingAbstractCodec {
    protected final SocketChannel channel;
    protected final InetSocketAddress socketAddress;

    public NonBlockingSocketAbstractCodec(boolean serverFlag, Poller poller, SocketChannel channel, ByteBuffer receiveBuffer, ByteBuffer sendBuffer, Logger logger) throws SocketException {
        super(serverFlag, poller, receiveBuffer, sendBuffer, channel.socket().getSendBufferSize(), logger);
        this.channel = channel;
        this.socketAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
        try {
            channel.configureBlocking(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        poller.add(channel, this, 1);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    protected void internalDestroy() {
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public InetSocketAddress getLastReadBufferSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public void invalidDataStreamHandler() {
        try {
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

