/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.codec;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.codec.ConnectionClosedException;
import org.epics.pvaccess.impl.remote.codec.InvalidDataStreamException;
import org.epics.pvaccess.util.Mailbox;

public abstract class AbstractCodec
implements ReadableByteChannel,
WritableByteChannel,
TransportSendControl {
    protected final Logger logger;
    public static final int MAX_MESSAGE_PROCESS = 100;
    public static final int MAX_MESSAGE_SEND = 100;
    public static final int MAX_ENSURE_SIZE = 1024;
    public static final int MAX_ENSURE_DATA_SIZE = 512;
    public static final int MAX_ENSURE_BUFFER_SIZE = 1024;
    protected final ByteBuffer socketBuffer;
    protected ReadMode readMode = ReadMode.NORMAL;
    protected byte version;
    protected byte flags;
    protected byte command;
    protected int payloadSize;
    private int storedPayloadSize;
    private int storedPosition;
    private int storedLimit;
    private int startPosition;
    protected final ByteBuffer sendBuffer;
    private final int maxSendPayloadSize;
    private int lastMessageStartPosition = -1;
    private byte lastSegmentedMessageType = 0;
    private byte lastSegmentedMessageCommand = 0;
    private int nextMessagePayloadOffset = 0;
    private int byteOrderFlag = 128;
    private final int clientServerFlag;
    private final int socketSendBufferSize;
    protected int remoteTransportSocketReceiveBufferSize = 16384;
    protected long totalBytesSent = 0L;
    protected final Mailbox<TransportSender> sendQueue = new Mailbox();
    protected final boolean blockingProcessQueue;
    private Thread senderThread = null;
    protected InetSocketAddress sendTo;
    static final byte[] PADDING_BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
    protected WriteMode writeMode = WriteMode.PROCESS_SEND_QUEUE;
    protected boolean writeOpReady = false;
    final boolean lowLatency = false;

    public AbstractCodec(boolean serverFlag, ByteBuffer receiveBuffer, ByteBuffer sendBuffer, int socketSendBufferSize, boolean blockingProcessQueue, Logger logger) {
        if (receiveBuffer.capacity() < 2048) {
            throw new IllegalArgumentException("receiveBuffer.capacity() < 2*MAX_ENSURE_SIZE");
        }
        if (receiveBuffer.capacity() % 1 != 0) {
            throw new IllegalArgumentException("receiveBuffer.capacity() % PVAConstants.PVA_ALIGNMENT != 0");
        }
        if (sendBuffer.capacity() < 2048) {
            throw new IllegalArgumentException("sendBuffer() < 2*MAX_ENSURE_SIZE");
        }
        if (sendBuffer.capacity() % 1 != 0) {
            throw new IllegalArgumentException("sendBuffer() % PVAConstants.PVA_ALIGNMENT != 0");
        }
        this.clientServerFlag = serverFlag ? 64 : 0;
        this.socketBuffer = receiveBuffer;
        this.sendBuffer = sendBuffer;
        this.socketBuffer.position(this.socketBuffer.limit());
        this.startPosition = this.socketBuffer.position();
        sendBuffer.clear();
        this.maxSendPayloadSize = sendBuffer.capacity() - 16;
        this.socketSendBufferSize = socketSendBufferSize;
        this.blockingProcessQueue = blockingProcessQueue;
        this.logger = logger;
    }

    public final void processRead() throws IOException, ConnectionClosedException, InvalidDataStreamException {
        switch (this.readMode) {
            case NORMAL: {
                this.processReadNormal();
                break;
            }
            case SEGMENTED: {
                this.processReadSegmented();
            }
        }
    }

    private final void processHeader() throws IOException {
        byte magicCode = this.socketBuffer.get();
        this.version = this.socketBuffer.get();
        this.flags = this.socketBuffer.get();
        this.command = this.socketBuffer.get();
        this.payloadSize = this.socketBuffer.getInt();
        if (magicCode != -54) {
            this.logger.warning("Invalid header received from client " + this.getLastReadBufferSocketAddress() + ", disconnecting...");
            this.invalidDataStreamHandler();
            throw new InvalidDataStreamException("invalid header received");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processReadNormal() throws IOException {
        try {
            int messageProcessCount = 0;
            while (messageProcessCount++ < 100) {
                boolean notFirstSegment;
                boolean isControl;
                if (!this.readToBuffer(8, false)) {
                    return;
                }
                this.processHeader();
                boolean bl = isControl = (this.flags & 1) == 1;
                if (isControl) {
                    this.processControlMessage();
                    continue;
                }
                boolean bl2 = notFirstSegment = (this.flags & 0x20) != 0;
                if (notFirstSegment) {
                    if (this.payloadSize == 0) continue;
                    this.logger.warning("Not-a-first segmented message received in normal mode from client " + this.getLastReadBufferSocketAddress() + ", disconnecting...");
                    this.invalidDataStreamHandler();
                    throw new InvalidDataStreamException("not-a-first segmented message received in normal mode");
                }
                this.storedPayloadSize = this.payloadSize;
                this.storedPosition = this.socketBuffer.position();
                this.storedLimit = this.socketBuffer.limit();
                this.socketBuffer.limit(Math.min(this.storedPosition + this.storedPayloadSize, this.storedLimit));
                Throwable storedException = null;
                try {
                    this.processApplicationMessage();
                }
                finally {
                    int newPosition;
                    if (!this.isOpen()) {
                        return;
                    }
                    while ((newPosition = AbstractCodec.alignedValue(this.storedPosition + this.storedPayloadSize, 1)) > this.storedLimit) {
                        int bytesNotRead = newPosition - this.socketBuffer.position();
                        if (bytesNotRead < 1) {
                            this.storedPayloadSize += bytesNotRead;
                            this.socketBuffer.limit(this.storedLimit);
                            this.ensureData(bytesNotRead);
                            this.storedPayloadSize -= bytesNotRead;
                            continue;
                        }
                        this.logger.log(Level.WARNING, "unprocessed read buffer from client " + this.getLastReadBufferSocketAddress() + ", disconnecting...", storedException);
                        this.invalidDataStreamHandler();
                        throw new InvalidDataStreamException("unprocessed read buffer", storedException);
                    }
                    this.socketBuffer.limit(this.storedLimit);
                    this.socketBuffer.position(newPosition);
                }
            }
        }
        catch (InvalidDataStreamException messageProcessCount) {
        }
        catch (ConnectionClosedException messageProcessCount) {
        }
        catch (ClosedByInterruptException cbie) {
            this.close();
        }
    }

    private final void processReadSegmented() throws IOException {
        boolean notFirstSegment;
        while (true) {
            boolean isControl;
            this.readToBuffer(8, true);
            this.processHeader();
            boolean bl = isControl = (this.flags & 1) == 1;
            if (!isControl) break;
            this.processControlMessage();
        }
        boolean bl = notFirstSegment = (this.flags & 0x20) != 0;
        if (!notFirstSegment) {
            this.logger.warning("Not-a-first segmented message expected from client " + this.getLastReadBufferSocketAddress() + ", disconnecting...");
            this.invalidDataStreamHandler();
            throw new InvalidDataStreamException("not-a-first segmented message expected");
        }
        this.storedPayloadSize = this.payloadSize;
    }

    public abstract void processControlMessage();

    public abstract void processApplicationMessage() throws IOException;

    public abstract InetSocketAddress getLastReadBufferSocketAddress();

    public abstract void invalidDataStreamHandler();

    private boolean readToBuffer(int requiredBytes, boolean persistent) throws IOException {
        int remainingBytes = this.socketBuffer.remaining();
        if (remainingBytes >= requiredBytes) {
            return true;
        }
        this.startPosition = 1024 + this.socketBuffer.position() % 1;
        int endPosition = this.startPosition + remainingBytes;
        for (int i = this.startPosition; i < endPosition; ++i) {
            this.socketBuffer.put(i, this.socketBuffer.get());
        }
        this.socketBuffer.limit(this.socketBuffer.capacity());
        this.socketBuffer.position(endPosition);
        int requiredPosition = this.startPosition + requiredBytes;
        while (this.socketBuffer.position() < requiredPosition) {
            int bytesRead = this.read(this.socketBuffer);
            if (bytesRead < 0) {
                this.close();
                throw new ConnectionClosedException("bytesRead < 0");
            }
            if (bytesRead != 0) continue;
            if (persistent) {
                this.readPollOne();
                continue;
            }
            this.socketBuffer.limit(this.socketBuffer.position());
            this.socketBuffer.position(this.startPosition);
            return false;
        }
        this.socketBuffer.limit(this.socketBuffer.position());
        this.socketBuffer.position(this.startPosition);
        return true;
    }

    public abstract void readPollOne() throws IOException;

    public final void ensureData(int size) {
        if (this.socketBuffer.remaining() >= size) {
            return;
        }
        if (size > 512) {
            throw new IllegalArgumentException("requested for buffer size " + size + ", but maximum " + 512 + " is allowed.");
        }
        try {
            int pos = this.socketBuffer.position();
            this.storedPayloadSize -= pos - this.storedPosition;
            if (this.storedPayloadSize >= this.storedLimit - pos) {
                ReadMode storedMode = this.readMode;
                this.readMode = ReadMode.SPLIT;
                this.readToBuffer(size, true);
                this.readMode = storedMode;
                this.storedPosition = this.socketBuffer.position();
                this.storedLimit = this.socketBuffer.limit();
                this.socketBuffer.limit(Math.min(this.storedPosition + this.storedPayloadSize, this.storedLimit));
                this.ensureData(size);
            } else {
                int remainingBytes = this.socketBuffer.remaining();
                for (int i = 0; i < remainingBytes; ++i) {
                    this.socketBuffer.put(i, this.socketBuffer.get());
                }
                this.socketBuffer.limit(this.storedLimit);
                int storedAlignmentOffset = this.socketBuffer.position() % 1;
                if (storedAlignmentOffset > 0) {
                    int toSkip = 1 - storedAlignmentOffset;
                    this.readToBuffer(toSkip, true);
                    int currentPos = this.socketBuffer.position();
                    this.socketBuffer.position(currentPos + toSkip);
                }
                ReadMode storedMode = this.readMode;
                this.readMode = ReadMode.SEGMENTED;
                this.processRead();
                this.readMode = storedMode;
                this.readToBuffer(size - remainingBytes + storedAlignmentOffset, true);
                this.socketBuffer.position(this.socketBuffer.position() + storedAlignmentOffset);
                int i = remainingBytes - 1;
                int j = this.socketBuffer.position() - 1;
                while (i >= 0) {
                    this.socketBuffer.put(j, this.socketBuffer.get(i));
                    --i;
                    --j;
                }
                this.startPosition = this.socketBuffer.position() - remainingBytes;
                this.socketBuffer.position(this.startPosition);
                this.storedPayloadSize += remainingBytes - storedAlignmentOffset;
                this.storedPosition = this.startPosition;
                this.storedLimit = this.socketBuffer.limit();
                this.socketBuffer.limit(Math.min(this.storedPosition + this.storedPayloadSize, this.storedLimit));
                this.ensureData(size);
            }
        }
        catch (IOException ex) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ConnectionClosedException("Failed to ensure data to read buffer.", ex);
        }
    }

    public static final int alignedValue(int value, int alignment) {
        int k = alignment - 1;
        return value + k & ~k;
    }

    public void alignData(int alignment) {
        int newpos;
        int k = alignment - 1;
        int pos = this.socketBuffer.position();
        if (pos == (newpos = pos + k & ~k)) {
            return;
        }
        int diff = this.socketBuffer.limit() - newpos;
        if (diff > 0) {
            this.socketBuffer.position(newpos);
            return;
        }
        this.ensureData(diff);
        newpos = this.socketBuffer.position() + k & ~k;
        this.socketBuffer.position(newpos);
    }

    public abstract void writePollOne() throws IOException;

    public void alignBuffer(int alignment) {
        int newpos;
        int k = alignment - 1;
        int pos = this.sendBuffer.position();
        if (pos == (newpos = pos + k & ~k)) {
            return;
        }
        int padCount = newpos - pos;
        this.sendBuffer.put(PADDING_BYTES, 0, padCount);
    }

    @Override
    public final void startMessage(byte command, int ensureCapacity) {
        this.lastMessageStartPosition = -1;
        this.ensureBuffer(8 + ensureCapacity + this.nextMessagePayloadOffset);
        this.lastMessageStartPosition = this.sendBuffer.position();
        this.sendBuffer.put((byte)-54);
        this.sendBuffer.put((byte)1);
        this.sendBuffer.put((byte)(this.lastSegmentedMessageType | this.byteOrderFlag | this.clientServerFlag));
        this.sendBuffer.put(command);
        this.sendBuffer.putInt(0);
        if (this.nextMessagePayloadOffset > 0) {
            this.sendBuffer.position(this.sendBuffer.position() + this.nextMessagePayloadOffset);
        }
    }

    public final void putControlMessage(byte command, int data) {
        this.lastMessageStartPosition = -1;
        this.ensureBuffer(8);
        this.sendBuffer.put((byte)-54);
        this.sendBuffer.put((byte)1);
        this.sendBuffer.put((byte)(1 | this.byteOrderFlag | this.clientServerFlag));
        this.sendBuffer.put(command);
        this.sendBuffer.putInt(data);
    }

    @Override
    public final void endMessage() {
        this.endMessage(false);
    }

    private final void endMessage(boolean hasMoreSegments) {
        if (this.lastMessageStartPosition >= 0) {
            int lastPayloadBytePosition = this.sendBuffer.position();
            this.alignBuffer(1);
            int payloadSize = lastPayloadBytePosition - this.lastMessageStartPosition - 8;
            this.sendBuffer.putInt(this.lastMessageStartPosition + 4, payloadSize);
            if (hasMoreSegments) {
                if (this.lastSegmentedMessageType == 0) {
                    int flagsPosition = this.lastMessageStartPosition + 2;
                    byte type = this.sendBuffer.get(flagsPosition);
                    this.sendBuffer.put(flagsPosition, (byte)(type | 0x10));
                    this.lastSegmentedMessageType = (byte)(type | 0x30);
                    this.lastSegmentedMessageCommand = this.sendBuffer.get(flagsPosition + 1);
                }
                this.nextMessagePayloadOffset = lastPayloadBytePosition % 1;
            } else {
                if (this.lastSegmentedMessageType != 0) {
                    int flagsPosition = this.lastMessageStartPosition + 2;
                    this.sendBuffer.put(flagsPosition, (byte)(this.lastSegmentedMessageType & 0xEF));
                    this.lastSegmentedMessageType = 0;
                }
                this.nextMessagePayloadOffset = 0;
            }
            this.lastMessageStartPosition = -1;
        }
    }

    public final void ensureBuffer(int size) {
        if (this.sendBuffer.remaining() >= size) {
            return;
        }
        if (this.maxSendPayloadSize < size) {
            throw new IllegalArgumentException("requested for buffer size " + size + ", but only " + this.maxSendPayloadSize + " available.");
        }
        while (this.sendBuffer.remaining() < size) {
            this.flush(false);
        }
    }

    public void flushSerializeBuffer() {
        this.flush(false);
    }

    @Override
    public void flush(boolean lastMessageCompleted) {
        this.endMessage(!lastMessageCompleted);
        this.sendBuffer.flip();
        try {
            this.send(this.sendBuffer);
        }
        catch (IOException e) {
            try {
                if (this.isOpen()) {
                    this.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ConnectionClosedException("Failed to send buffer.", e);
        }
        this.sendBuffer.clear();
        this.lastMessageStartPosition = -1;
        if (!lastMessageCompleted && this.lastSegmentedMessageType != 0) {
            this.startMessage(this.lastSegmentedMessageCommand, 0);
        }
    }

    public final void processWrite() throws IOException, ConnectionClosedException {
        switch (this.writeMode) {
            case PROCESS_SEND_QUEUE: {
                this.processSendQueue();
                break;
            }
            case WAIT_FOR_READY_SIGNAL: {
                this.writeOpReady = true;
            }
        }
    }

    protected void send(ByteBuffer buffer) throws IOException {
        int maxBytesToSend = Math.min(this.socketSendBufferSize, this.remoteTransportSocketReceiveBufferSize) / 2;
        int limit = buffer.limit();
        int bytesToSend = limit - buffer.position();
        if (bytesToSend > maxBytesToSend) {
            bytesToSend = maxBytesToSend;
            buffer.limit(buffer.position() + bytesToSend);
        }
        int tries = 0;
        while (buffer.hasRemaining()) {
            int bytesSent = this.write(buffer);
            if (bytesSent < 0) {
                this.close();
                throw new ConnectionClosedException("bytesSent < 0");
            }
            if (bytesSent == 0) {
                this.sendBufferFull(tries++);
                continue;
            }
            this.totalBytesSent += (long)bytesSent;
            if (bytesToSend == maxBytesToSend) {
                bytesToSend = limit - buffer.position();
                if (bytesToSend > maxBytesToSend) {
                    bytesToSend = maxBytesToSend;
                }
                buffer.limit(buffer.position() + bytesToSend);
            }
            tries = 0;
        }
    }

    protected abstract void sendBufferFull(int var1) throws IOException;

    public abstract void scheduleSend();

    public abstract void sendCompleted();

    public final void processSendQueue() throws IOException {
        try {
            int senderProcessed = 0;
            while (senderProcessed++ < 100) {
                TransportSender sender = this.sendQueue.take(-1L);
                if (sender == null) {
                    if (this.sendBuffer.position() > 0) {
                        this.flush(true);
                    }
                    this.sendCompleted();
                    if (this.blockingProcessQueue) {
                        if (this.terminated() || (sender = this.sendQueue.take(0L)) == null) {
                            break;
                        }
                    } else {
                        return;
                    }
                }
                this.processSender(sender);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.sendBuffer.position() > 0) {
            this.flush(true);
        }
    }

    public final void clearSendQueue() {
        this.sendQueue.clear();
    }

    public final void enqueueSendRequest(TransportSender sender) {
        this.sendQueue.put(sender);
        this.scheduleSend();
    }

    public void setSenderThread() {
        this.senderThread = Thread.currentThread();
    }

    private final void processSender(TransportSender sender) {
        sender.lock();
        try {
            this.lastMessageStartPosition = this.sendBuffer.position();
            sender.send(this.sendBuffer, this);
            this.endMessage(false);
        }
        catch (ConnectionClosedException cce) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ConnectionClosedException("exception caught: " + cce.getMessage());
        }
        catch (Throwable th) {
            this.logger.log(Level.FINE, "exception caught while processing send message", th);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ConnectionClosedException("exception caught: " + th.getMessage());
        }
        finally {
            sender.unlock();
        }
    }

    public final void enqueueSendRequest(TransportSender sender, int requiredBufferSize) {
        if (this.senderThread == Thread.currentThread() && this.sendQueue.isEmpty() && this.sendBuffer.remaining() >= requiredBufferSize) {
            this.processSender(sender);
            if (this.sendBuffer.position() > 0) {
                this.scheduleSend();
            }
        } else {
            this.enqueueSendRequest(sender);
        }
    }

    @Override
    public void setRecipient(InetSocketAddress sendTo) {
        this.sendTo = sendTo;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.socketBuffer.order(byteOrder);
        this.sendBuffer.order(byteOrder);
        this.byteOrderFlag = ByteOrder.BIG_ENDIAN == byteOrder ? 128 : 0;
    }

    public abstract boolean terminated();

    public static enum WriteMode {
        PROCESS_SEND_QUEUE,
        WAIT_FOR_READY_SIGNAL;

    }

    public static enum ReadMode {
        NORMAL,
        SPLIT,
        SEGMENTED;

    }
}

