/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.epics.pvaccess.impl.remote.Transport;

public final class TransportRegistry {
    private Map<InetSocketAddress, Map<Short, Transport>> transports = Collections.synchronizedMap(new HashMap());
    private List<Transport> allTransports = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Transport transport) {
        short priority = transport.getPriority();
        InetSocketAddress address = transport.getRemoteAddress();
        Map<InetSocketAddress, Map<Short, Transport>> map = this.transports;
        synchronized (map) {
            Map<Short, Transport> priorities = this.transports.get(address);
            if (priorities == null) {
                priorities = Collections.synchronizedMap(new HashMap());
                this.transports.put(address, priorities);
            }
            priorities.put(priority, transport);
            this.allTransports.add(transport);
        }
    }

    public synchronized Transport get(String type, InetSocketAddress address, short priority) {
        Map<Short, Transport> priorities = this.transports.get(address);
        if (priorities != null) {
            return priorities.get(priority);
        }
        return null;
    }

    public synchronized Transport[] get(String type, InetSocketAddress address) {
        Map<Short, Transport> priorities = this.transports.get(address);
        if (priorities != null) {
            Transport[] ts = new Transport[priorities.size()];
            priorities.values().toArray(ts);
            return ts;
        }
        return null;
    }

    public synchronized Transport remove(Transport transport) {
        short priority = transport.getPriority();
        InetSocketAddress address = transport.getRemoteAddress();
        Map<Short, Transport> priorities = this.transports.get(address);
        if (priorities != null) {
            transport = priorities.remove(priority);
            if (priorities.size() == 0) {
                this.transports.remove(address);
            }
            if (transport != null) {
                this.allTransports.remove(transport);
            }
            return transport;
        }
        return null;
    }

    public synchronized void clear() {
        this.transports.clear();
        this.allTransports.clear();
    }

    public synchronized int numberOfActiveTransports() {
        return this.allTransports.size();
    }

    public synchronized Transport[] toArray(String type) {
        return this.allTransports.toArray(new Transport[this.transports.size()]);
    }

    public synchronized Transport[] toArray() {
        return this.allTransports.toArray(new Transport[this.transports.size()]);
    }
}

