/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.pvms;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.epics.pvaccess.client.pvms.IncomingMulticastIntrospectionRegistry;
import org.epics.pvaccess.client.pvms.PVMSCodec;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;

class PVMSSubscriber
extends PVMSCodec
implements DeserializableControl {
    private static PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private final MulticastSocket socket;
    private final DatagramPacket packet;
    private final ByteBuffer buffer = ByteBuffer.allocate(65487);
    private IncomingMulticastIntrospectionRegistry activeRegistry = null;
    private final Map<PublisherInfo, IncomingMulticastIntrospectionRegistry> publishers = new HashMap<PublisherInfo, IncomingMulticastIntrospectionRegistry>();
    private boolean destroyed = false;
    private final Set<InetAddress> joinedGroups = new HashSet<InetAddress>();
    private PublisherInfo cachedPI = new PublisherInfo();

    public PVMSSubscriber(InetAddress address, int port) throws IOException {
        this.socket = new MulticastSocket(port);
        this.socket.joinGroup(address);
        this.packet = new DatagramPacket(this.buffer.array(), this.buffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinGroup(InetAddress address) throws IOException {
        Set<InetAddress> set = this.joinedGroups;
        synchronized (set) {
            if (!this.joinedGroups.contains(address)) {
                this.socket.joinGroup(address);
                this.joinedGroups.add(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveGroup(InetAddress address) throws IOException {
        Set<InetAddress> set = this.joinedGroups;
        synchronized (set) {
            if (this.joinedGroups.contains(address)) {
                this.socket.leaveGroup(address);
                this.joinedGroups.add(address);
            }
        }
    }

    public void unsubscribe(String topicId) throws IOException {
    }

    public void ensureData(int size) {
    }

    public void alignData(int alignment) {
    }

    public Field cachedDeserialize(ByteBuffer buffer) {
        return this.activeRegistry.deserialize(buffer, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(PVMSMessage message, String[] filterTags) throws IOException {
        String[] tags;
        while (true) {
            int tagsCount;
            this.socket.receive(this.packet);
            InetSocketAddress socketAddress = (InetSocketAddress)this.packet.getSocketAddress();
            this.buffer.clear();
            this.buffer.limit(this.packet.getLength());
            int t = this.buffer.getInt();
            int t2 = this.buffer.getInt();
            long id = this.buffer.getLong();
            int seqNum = t & Integer.MAX_VALUE;
            if (t != seqNum) {
                this.handleControlPacket(this.buffer, socketAddress, t, t2, id);
                continue;
            }
            int positionFlags = t2 & 0xC0000000;
            if (positionFlags != PVMSCodec.PacketPosition.SOLO.getMaskValue()) continue;
            Map<PublisherInfo, IncomingMulticastIntrospectionRegistry> map = this.publishers;
            synchronized (map) {
                this.cachedPI.set(id, socketAddress);
                this.activeRegistry = this.publishers.get(this.cachedPI);
                if (this.activeRegistry == null) {
                    this.activeRegistry = new IncomingMulticastIntrospectionRegistry();
                    this.publishers.put(this.cachedPI, this.activeRegistry);
                    this.cachedPI = new PublisherInfo();
                }
            }
            String topicId = SerializeHelper.deserializeString((ByteBuffer)this.buffer, (DeserializableControl)this);
            if (message.topicId != null) {
                if (!message.topicId.equals(topicId)) {
                    continue;
                }
            } else {
                message.topicId = topicId;
            }
            tags = (tagsCount = SerializeHelper.readSize((ByteBuffer)this.buffer, (DeserializableControl)this)) > 0 ? new String[tagsCount] : null;
            for (int i = 0; i < tagsCount; ++i) {
                tags[i] = SerializeHelper.deserializeString((ByteBuffer)this.buffer, (DeserializableControl)this);
            }
            if (filterTags == null || filterTags.length <= 0) break;
            if (tags.length < filterTags.length) continue;
            boolean notSubSet = false;
            HashSet<String> hashSet = new HashSet<String>();
            for (String tag : tags) {
                hashSet.add(tag);
            }
            for (String tag : filterTags) {
                if (hashSet.contains(tag)) continue;
                notSubSet = true;
                break;
            }
            if (!notSubSet) break;
        }
        message.tags = tags;
        Field field = this.cachedDeserialize(this.buffer);
        if (field == null) {
            message.data = null;
            return;
        }
        if (message.data == null || !message.data.getField().equals(field)) {
            message.data = pvDataCreate.createPVField(field);
        }
        message.data.deserialize(this.buffer, (DeserializableControl)this);
    }

    @Override
    protected void handleKeepAlive(InetSocketAddress socketAddress, long id, int expirationTimeSec) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleShutdown(InetSocketAddress socketAddress, long id) {
        Map<PublisherInfo, IncomingMulticastIntrospectionRegistry> map = this.publishers;
        synchronized (map) {
            this.cachedPI.set(id, socketAddress);
            this.activeRegistry = this.publishers.remove(this.cachedPI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            Set<InetAddress> set = this.joinedGroups;
            synchronized (set) {
                for (InetAddress g : this.joinedGroups) {
                    this.socket.leaveGroup(g);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket.close();
    }

    public static class PVMSMessage {
        public String topicId;
        public String[] tags;
        public PVField data;

        public PVMSMessage(String topicId, String[] tags, PVField data) {
            this.topicId = topicId;
            this.tags = tags;
            this.data = data;
        }
    }

    private static class PublisherInfo {
        public long id;
        public InetSocketAddress socketAddress;

        private PublisherInfo() {
        }

        public void set(long id, InetSocketAddress socketAddress) {
            this.id = id;
            this.socketAddress = socketAddress;
        }

        public int hashCode() {
            return (int)this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PublisherInfo other = (PublisherInfo)obj;
            if (this.id != other.id) {
                return false;
            }
            return !(this.socketAddress == null ? other.socketAddress != null : !this.socketAddress.equals(other.socketAddress));
        }
    }
}

