/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.pvms;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.epics.pvaccess.client.pvms.PVMSPublisher;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVLong;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PVStructureArray;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.Structure;

public class PVMSLogger {
    public static final String TOPIC_ID = "log";
    public static final Structure timeStructure = FieldFactory.getFieldCreate().createFieldBuilder().setId("time_t").add("secsPastEpoch", ScalarType.pvLong).add("nanoseconds", ScalarType.pvInt).add("userTag", ScalarType.pvInt).createStructure();
    public static final Structure nameValue = FieldFactory.getFieldCreate().createFieldBuilder().add("name", ScalarType.pvString).add("value", ScalarType.pvString).createStructure();
    public static final Structure logStructure = FieldFactory.getFieldCreate().createFieldBuilder().setId("epics:test/NTLogRecord:1.0").add("uuid_msb", ScalarType.pvLong).add("uuid_lsb", ScalarType.pvLong).add("seqNo", ScalarType.pvLong).add("time", (Field)timeStructure).add("level", ScalarType.pvInt).add("loggerName", ScalarType.pvString).add("message", ScalarType.pvString).add("host", ScalarType.pvString).add("process", ScalarType.pvString).add("stackTrace", ScalarType.pvString).addArray("properties", (Field)nameValue).createStructure();

    public static void installPVMSLogging(Level logLevel, InetAddress sendAddress, int port) throws IOException {
        PVMSLogingHandler handler = new PVMSLogingHandler(sendAddress, port);
        LogManager.getLogManager().reset();
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
        rootLogger.addHandler(handler);
    }

    public static void main(String[] args) throws Throwable {
        InetAddress address = InetAddress.getByName("224.0.0.1");
        int port = 5678;
        PVMSLogger.installPVMSLogging(Level.INFO, address, 5678);
        Logger logger = Logger.getLogger("myLogger");
        logger.info("Hello world!");
        logger.finest("finest");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("entity", "myTwiss");
        props.put("uuid", "31");
        logger.log(Level.SEVERE, "ups, I did it again", new Object[]{props});
        logger.log(Level.WARNING, "wow, first error", new RuntimeException("rte 1"));
        logger.log(Level.WARNING, "wow, second error", new RuntimeException("rte 2"));
    }

    public static class PVMSLogingHandler
    extends Handler {
        private final PVStructure log = PVDataFactory.getPVDataCreate().createPVStructure(logStructure);
        private final PVLong seqNo = (PVLong)this.log.getSubField(PVLong.class, "seqNo");
        private final PVStructure time = (PVStructure)this.log.getSubField(PVStructure.class, "time");
        private final PVLong secsPastEpoch = (PVLong)this.time.getSubField(PVLong.class, "secsPastEpoch");
        private final PVInt nanoseconds = (PVInt)this.time.getSubField(PVInt.class, "nanoseconds");
        private final PVInt level = (PVInt)this.log.getSubField(PVInt.class, "level");
        private final PVString loggerName = (PVString)this.log.getSubField(PVString.class, "loggerName");
        private final PVString message = (PVString)this.log.getSubField(PVString.class, "message");
        private final PVString stackTrace = (PVString)this.log.getSubField(PVString.class, "stackTrace");
        private final PVStructureArray properties = (PVStructureArray)this.log.getSubField(PVStructureArray.class, "properties");
        private final AtomicLong sequenceNoCounter = new AtomicLong(0L);
        private final PVMSPublisher publisher;
        private final String[] tags;
        private final StringWriter stackTraceWriter = new StringWriter();
        private final PrintWriter stackTracePrinter = new PrintWriter(this.stackTraceWriter);
        private static String hostName = null;
        private static final String HOSTNAME_KEY = "HOSTNAME";

        public PVMSLogingHandler(InetAddress sendAddress, int port) throws IOException {
            this.publisher = new PVMSPublisher(sendAddress, port);
            UUID uuid = UUID.randomUUID();
            ((PVLong)this.log.getSubField(PVLong.class, "uuid_msb")).put(uuid.getMostSignificantBits());
            ((PVLong)this.log.getSubField(PVLong.class, "uuid_lsb")).put(uuid.getLeastSignificantBits());
            ((PVInt)this.time.getSubField(PVInt.class, "userTag")).put(0);
            ((PVString)this.log.getSubField(PVString.class, "host")).put(PVMSLogingHandler.getHostName());
            String cmdLine = System.getProperty("sun.java.command", "");
            int pos = cmdLine.indexOf(32);
            if (pos > 0) {
                cmdLine = cmdLine.substring(0, pos);
            }
            ((PVString)this.log.getSubField(PVString.class, "process")).put(cmdLine);
            this.tags = new String[]{PVMSLogingHandler.getHostName(), cmdLine};
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                this.seqNo.put(this.sequenceNoCounter.getAndIncrement());
                long t = record.getMillis();
                this.secsPastEpoch.put(t / 1000L);
                this.nanoseconds.put((int)(t % 1000L * 1000000L));
                this.level.put(record.getLevel().intValue());
                this.loggerName.put(record.getLoggerName());
                this.message.put(record.getMessage());
                Throwable th = record.getThrown();
                if (th != null) {
                    th.printStackTrace(this.stackTracePrinter);
                    this.stackTrace.put(this.stackTraceWriter.toString());
                    this.stackTraceWriter.getBuffer().setLength(0);
                } else {
                    this.stackTrace.put(null);
                }
                Object[] parameters = record.getParameters();
                if (parameters != null && parameters.length > 0) {
                    ArrayList<PVStructure> params = new ArrayList<PVStructure>();
                    for (Object o : parameters) {
                        if (!(o instanceof Map)) continue;
                        Map map = (Map)o;
                        Set entries = map.entrySet();
                        for (Map.Entry entry : entries) {
                            PVStructure nv = PVDataFactory.getPVDataCreate().createPVStructure(nameValue);
                            ((PVString)nv.getSubField(PVString.class, "name")).put((String)entry.getKey());
                            ((PVString)nv.getSubField(PVString.class, "value")).put((String)entry.getValue());
                            params.add(nv);
                        }
                    }
                    this.properties.setLength(params.size());
                    this.properties.put(0, params.size(), params.toArray(new PVStructure[params.size()]), 0);
                } else {
                    this.properties.setLength(0);
                }
                try {
                    this.publisher.publishData(PVMSLogger.TOPIC_ID, this.tags, (PVField)this.log);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
            this.publisher.destroy();
        }

        private static synchronized String getHostName() {
            if (hostName == null) {
                hostName = "localhost";
                try {
                    InetAddress localAddress = InetAddress.getLocalHost();
                    hostName = localAddress.getHostName();
                }
                catch (Throwable uhe) {
                    try {
                        String envHN = System.getenv(HOSTNAME_KEY);
                        if (envHN != null) {
                            hostName = envHN;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    hostName = System.getProperty(HOSTNAME_KEY, hostName);
                }
            }
            return hostName;
        }
    }
}

