/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.pvms;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.epics.pvdata.misc.SerializeHelper;

public class PVMSCodec {
    private final AtomicInteger packetSequenceNumber = new AtomicInteger(0);
    private final AtomicInteger messageSequenceNumber = new AtomicInteger(0);
    private final long timeStamp = System.currentTimeMillis();

    public final int incrementPacketSeqNum() {
        int next;
        int current;
        while (!this.packetSequenceNumber.compareAndSet(current = this.packetSequenceNumber.get(), next = current + 1 & Integer.MAX_VALUE)) {
        }
        return current;
    }

    public final int incrementMessageSeqNum() {
        int next;
        int current;
        while (!this.messageSequenceNumber.compareAndSet(current = this.messageSequenceNumber.get(), next = current + 1 & 0x1FFFFFFF)) {
        }
        return current;
    }

    protected void udtDataHeader(ByteBuffer buffer, int messageSeqNumber, PacketPosition packetPosition) {
        int seqNum = this.incrementPacketSeqNum();
        buffer.putInt(seqNum);
        int positionFlags = packetPosition.getMaskValue();
        int inOrderDeliveryRequiredFlag = 0x20000000;
        buffer.putInt(positionFlags | 0x20000000 | messageSeqNumber);
        buffer.putLong(this.timeStamp);
    }

    private void udtControlHeader(ByteBuffer buffer, int type, int reserved, int additionalInfo) {
        int controlTypeField = Integer.MIN_VALUE | type << 16 | reserved;
        buffer.putInt(controlTypeField);
        buffer.putInt(additionalInfo);
        buffer.putLong(this.timeStamp);
    }

    protected void pmsShutdownControlMessage(ByteBuffer buffer) {
        this.udtControlHeader(buffer, 5, 0, 0);
    }

    protected void pmsKeepAliveControlMessage(ByteBuffer buffer, int expirationTimeSec) {
        this.udtControlHeader(buffer, 1, 0, expirationTimeSec);
    }

    protected void pmsSubscribeControlMessage(ByteBuffer buffer, int expirationTimeSec, String topicID) {
        this.udtControlHeader(buffer, Short.MAX_VALUE, 51914, expirationTimeSec);
        SerializeHelper.serializeString((String)topicID, (ByteBuffer)buffer);
    }

    protected void handleControlPacket(ByteBuffer buffer, InetSocketAddress socketAddress, int typeReserved, int additionalInfo, long id) {
        int type = (typeReserved & Integer.MAX_VALUE) >> 16;
        switch (type) {
            case 1: {
                this.handleKeepAlive(socketAddress, id, additionalInfo);
                break;
            }
            case 5: {
                this.handleShutdown(socketAddress, id);
                break;
            }
            case 32767: {
                if (typeReserved == 2147470026) {
                    String topicId = SerializeHelper.deserializeString((ByteBuffer)buffer);
                    this.handleSubscribe(socketAddress, id, additionalInfo, topicId);
                    break;
                }
            }
            default: {
                throw new IllegalStateException("unsupported control message: 0x" + Integer.toHexString(typeReserved));
            }
        }
    }

    protected void handleKeepAlive(InetSocketAddress socketAddress, long id, int expirationTimeSec) {
    }

    protected void handleShutdown(InetSocketAddress socketAddress, long id) {
    }

    protected void handleSubscribe(InetSocketAddress socketAddress, long id, int expirationTimeSec, String topicId) {
    }

    public static enum PacketPosition {
        FIRST(Integer.MIN_VALUE),
        LAST(0x40000000),
        SOLO(-1073741824),
        MIDDLE(0);

        private final int maskValue;

        private PacketPosition(int maskValue) {
            this.maskValue = maskValue;
        }

        public final int getMaskValue() {
            return this.maskValue;
        }
    }
}

