/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import org.epics.pvaccess.impl.remote.ConnectionException;
import org.epics.pvaccess.impl.remote.Connector;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.ProtocolType;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportClient;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.util.sync.NamedLockPattern;

public class BlockingTCPConnector
implements Connector {
    private final Context context;
    private final NamedLockPattern namedLocker;
    private static final int LOCK_TIMEOUT = 20000;
    private static final int VERIFICATION_TIMEOUT = 5000;
    private final int receiveBufferSize;
    private final float heartbeatInterval;
    private final TransportFactory transportFactory;

    public BlockingTCPConnector(Context context, TransportFactory transportFactory, int receiveBufferSize, float heartbeatInterval) {
        this.context = context;
        this.transportFactory = transportFactory;
        this.receiveBufferSize = receiveBufferSize;
        this.heartbeatInterval = heartbeatInterval;
        this.namedLocker = new NamedLockPattern();
    }

    @Override
    public Transport connect(TransportClient client, ResponseHandler responseHandler, InetSocketAddress address, byte transportRevision, short priority) throws ConnectionException {
        boolean lockAcquired;
        AbstractInterruptibleChannel socket = null;
        Transport transport = this.context.getTransportRegistry().get(ProtocolType.tcp.name(), address, priority);
        if (transport != null) {
            this.context.getLogger().finer("Reusing existant connection to PVA server: " + address);
            if (transport.acquire(client)) {
                return transport;
            }
        }
        if (lockAcquired = this.namedLocker.acquireSynchronizationObject(address, 20000L)) {
            try {
                transport = this.context.getTransportRegistry().get(ProtocolType.tcp.name(), address, priority);
                if (transport != null) {
                    this.context.getLogger().finer("Reusing existant connection to PVA server: " + address);
                    if (transport.acquire(client)) {
                        Transport transport2 = transport;
                        return transport2;
                    }
                }
                this.context.getLogger().finer("Connecting to PVA server: " + address);
                socket = this.tryConnect(address, 3);
                ((AbstractSelectableChannel)socket).configureBlocking(true);
                ((SocketChannel)socket).socket().setTcpNoDelay(true);
                ((SocketChannel)socket).socket().setKeepAlive(true);
                transport = this.transportFactory.create(this.context, (SocketChannel)socket, responseHandler, this.receiveBufferSize, client, transportRevision, this.heartbeatInterval, priority);
                if (!transport.verify(5000L)) {
                    this.context.getLogger().finer("Connection to PVA client " + address + " failed to be validated, closing it.");
                    transport.close();
                    throw new ConnectionException("Failed to verify connection to '" + address + "'.", address, ProtocolType.tcp.name(), null);
                }
                this.context.getLogger().finer("Connected to PVA server: " + address);
                Transport transport3 = transport;
                return transport3;
            }
            catch (Throwable th) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ConnectionException("Failed to connect to '" + address + "'.", address, ProtocolType.tcp.name(), th);
            }
            finally {
                this.namedLocker.releaseSynchronizationObject(address);
            }
        }
        throw new ConnectionException("Failed to obtain synchronization lock for '" + address + "', possible deadlock.", address, ProtocolType.tcp.name(), null);
    }

    private SocketChannel tryConnect(InetSocketAddress address, int tries) throws IOException {
        IOException lastException = null;
        for (int tryCount = 0; tryCount < tries; ++tryCount) {
            if (tryCount > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.context.getLogger().finest("Openning socket to PVA server " + address + ", attempt " + (tryCount + 1) + ".");
            try {
                return SocketChannel.open(address);
            }
            catch (IOException ioe) {
                lastException = ioe;
                continue;
            }
        }
        throw lastException;
    }

    public static interface TransportFactory {
        public Transport create(Context var1, SocketChannel var2, ResponseHandler var3, int var4, TransportClient var5, short var6, float var7, short var8);
    }
}

