/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportClient;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.impl.remote.tcp.BlockingTCPTransport;
import org.epics.pvaccess.impl.security.SecurityPluginMessageTransportSender;
import org.epics.pvaccess.plugins.SecurityPlugin;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.misc.Timer;
import org.epics.pvdata.misc.TimerFactory;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class BlockingClientTCPTransport
extends BlockingTCPTransport
implements Transport,
Timer.TimerCallback,
TransportSender,
SecurityPlugin.SecurityPluginControl {
    private Set<TransportClient> owners;
    private long connectionTimeout;
    private volatile boolean unresponsiveTransport = false;
    private Timer.TimerNode timerNode;
    private volatile long aliveTimestamp;
    final Object sendBufferFreed = new Object();
    private boolean verifyOrEcho = true;
    private volatile SecurityPlugin.SecuritySession securitySession = null;

    public BlockingClientTCPTransport(Context context, SocketChannel channel, ResponseHandler responseHandler, int receiveBufferSize, TransportClient client, short remoteTransportRevision, float heartbeatInterval, short priority) throws SocketException {
        super(context, channel, responseHandler, receiveBufferSize, priority);
        this.owners = new HashSet<TransportClient>();
        this.acquire(client);
        this.connectionTimeout = (long)(heartbeatInterval * 1000.0f);
        this.aliveTimestamp = System.currentTimeMillis();
        this.timerNode = TimerFactory.createNode((Timer.TimerCallback)this);
        context.getTimer().schedulePeriodic(this.timerNode, (double)heartbeatInterval, (double)heartbeatInterval);
        this.start();
    }

    @Override
    protected void internalClose() {
        super.internalClose();
        this.timerNode.cancel();
        this.closedNotifyClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closedNotifyClients() {
        Set<TransportClient> set = this.owners;
        synchronized (set) {
            int refs = this.owners.size();
            if (refs > 0) {
                this.context.getLogger().fine("Transport to " + this.socketAddress + " still has " + refs + " client(s) active and closing...");
                TransportClient[] clients = new TransportClient[refs];
                this.owners.toArray(clients);
                for (int i = 0; i < clients.length; ++i) {
                    try {
                        clients[i].transportClosed();
                        continue;
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
            }
            this.owners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean acquire(TransportClient client) {
        if (!this.isOpen()) {
            return false;
        }
        this.context.getLogger().finer("Acquiring transport to " + this.socketAddress + ".");
        Set<TransportClient> set = this.owners;
        synchronized (set) {
            if (!this.isOpen()) {
                return false;
            }
            this.owners.add(client);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release(TransportClient client) {
        if (!this.isOpen()) {
            return;
        }
        this.context.getLogger().finer("Releasing transport to " + this.socketAddress + ".");
        Set<TransportClient> set = this.owners;
        synchronized (set) {
            this.owners.remove(client);
            if (this.owners.size() == 0) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public final void aliveNotification() {
        this.aliveTimestamp = System.currentTimeMillis();
        if (this.unresponsiveTransport) {
            this.responsiveTransport();
        }
    }

    public void timerStopped() {
    }

    public void callback() {
        long diff = System.currentTimeMillis() - this.aliveTimestamp;
        if (diff > 3L * this.connectionTimeout / 2L) {
            this.unresponsiveTransport();
        } else if (diff >= 3L * this.connectionTimeout / 4L) {
            this.enqueueSendRequest(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responsiveTransport() {
        if (this.unresponsiveTransport) {
            this.unresponsiveTransport = false;
            Set<TransportClient> set = this.owners;
            synchronized (set) {
                for (TransportClient client : this.owners) {
                    try {
                        client.transportResponsive(this);
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unresponsiveTransport() {
        if (!this.unresponsiveTransport) {
            this.unresponsiveTransport = true;
            Set<TransportClient> set = this.owners;
            synchronized (set) {
                for (TransportClient client : this.owners) {
                    try {
                        client.transportUnresponsive();
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedTransport() {
        this.outgoingIR.reset();
        Set<TransportClient> set = this.owners;
        synchronized (set) {
            for (TransportClient client : this.owners) {
                try {
                    client.transportChanged();
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        if (this.verifyOrEcho) {
            control.startMessage((byte)1, 8);
            buffer.putInt(this.getReceiveBufferSize());
            buffer.putShort((short)Short.MAX_VALUE);
            buffer.putShort(this.getPriority());
            String securityPluginName = this.securitySession != null ? this.securitySession.getSecurityPlugin().getId() : "";
            SerializeHelper.serializeString((String)securityPluginName, (ByteBuffer)buffer, (SerializableControl)control);
            if (this.securitySession != null) {
                SerializationHelper.serializeFull(buffer, control, this.securitySession.initializationData());
            } else {
                SerializationHelper.serializeNullField(buffer, control);
            }
            control.flush(true);
            this.verifyOrEcho = false;
        } else {
            control.startMessage((byte)2, 0);
            control.flush(true);
        }
    }

    @Override
    public void authNZInitialize(Object data) {
        List offeredSecurityPlugins = (List)data;
        if (!offeredSecurityPlugins.isEmpty()) {
            InetSocketAddress remoteAddress = (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
            Map<String, SecurityPlugin> availableSecurityPlugins = this.context.getSecurityPlugins();
            for (String offeredSPName : offeredSecurityPlugins) {
                try {
                    SecurityPlugin securityPlugin = availableSecurityPlugins.get(offeredSPName);
                    if (securityPlugin == null || !securityPlugin.isValidFor(remoteAddress)) continue;
                    this.securitySession = securityPlugin.createSession(remoteAddress, this, null);
                }
                catch (Throwable th) {
                    this.context.getLogger().log(Level.SEVERE, "Unexpected exception caught while calling SecurityPluin.isValidFor(InetAddress) methods.", th);
                }
            }
        }
        this.enqueueSendRequest(this);
    }

    @Override
    public void authNZMessage(PVField data) {
        SecurityPlugin.SecuritySession ss = this.securitySession;
        if (ss != null) {
            ss.messageReceived(data);
        } else {
            this.context.getLogger().warning("authNZ message received but no security plug-in session active");
        }
    }

    @Override
    public void sendSecurityPluginMessage(PVField data) {
        this.enqueueSendRequest(new SecurityPluginMessageTransportSender(data));
    }

    @Override
    public void authenticationCompleted(Status status) {
    }

    @Override
    public void close() throws IOException {
        if (this.securitySession != null) {
            try {
                this.securitySession.close();
            }
            catch (Throwable th) {
                this.context.getLogger().log(Level.WARNING, "Unexpection exception caight while closing secutiry session.", th);
            }
            this.securitySession = null;
        }
        super.close();
    }

    @Override
    public SecurityPlugin.SecuritySession getSecuritySession() {
        return this.securitySession;
    }
}

